/*
 * Copyright 2017 Juergen Fickel
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.retujo.bierverkostung.country;

import org.junit.Test;

import nl.jqno.equalsverifier.EqualsVerifier;

import static org.assertj.core.api.Assertions.assertThat;
import static org.mutabilitydetector.unittesting.MutabilityAssert.assertInstancesOf;
import static org.mutabilitydetector.unittesting.MutabilityMatchers.areImmutable;

/**
 * Unit test for {@link ImmutableCountry}.
 *
 * @since 1.0.0
 */
public final class ImmutableCountryTest {

    private static final String NAME = "Deutschland";

    /** */
    @Test
    public void assertImmutability() {
        assertInstancesOf(ImmutableCountry.class, areImmutable());
    }

    /** */
    @Test
    public void checkEqualsAndHashCode() {
        EqualsVerifier.forClass(ImmutableCountry.class)
                .usingGetClass()
                .verify();
    }

    /** */
    @Test
    public void getNameReturnsExpected() {
        final ImmutableCountry underTest = ImmutableCountry.newInstance(3L, NAME);

        assertThat(underTest.getName()).isEqualTo(NAME);
    }

}