/*
 * Copyright 2017 Juergen Fickel
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.retujo.bierverkostung.data;

import android.net.Uri;
import android.os.Parcelable;

import javax.annotation.Nonnull;

import de.retujo.java.util.Maybe;

/**
 * {@code RowData} is the link from database layer to the domain model. An implementation of this class is Parcelable
 * and thus can be used to share domain model objects with Intents.
 *
 * @since 1.0.0
 */
public interface RowData extends Parcelable, ContentValuesRepresentable {

    /**
     * Returns the identifier of this data entity.
     *
     * @return the identifier or an empty Maybe.
     */
    @Nonnull
    Maybe<Long> getId();

    /**
     * Returns the content URI of this row data.
     *
     * @return the content URI.
     */
    @Nonnull
    Uri getContentUri();

}
