/*
 * Copyright 2017 Juergen Fickel
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.retujo.bierverkostung.brewery;

import javax.annotation.Nonnull;

import de.retujo.bierverkostung.country.Country;
import de.retujo.bierverkostung.data.RowData;
import de.retujo.java.util.Maybe;

/**
 * This interface represents a brewery.
 *
 * @since 1.0.0
 */
public interface Brewery extends RowData {

    /**
     * Returns the name of the brewery.
     *
     * @return the name.
     */
    @Nonnull
    String getName();

    /**
     * Returns the location of the brewery.
     *
     * @return the location or an empty Maybe.
     */
    @Nonnull
    Maybe<String> getLocation();

    /**
     * Returns the country of the brewery.
     *
     * @return the country or an empty Maybe.
     */
    @Nonnull
    Maybe<Country> getCountry();

}
