/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *  strict-local
 * @format
 */
"use strict";

function _toConsumableArray(arr) {
  return (
    _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread()
  );
}

function _nonIterableSpread() {
  throw new TypeError("Invalid attempt to spread non-iterable instance");
}

function _iterableToArray(iter) {
  if (
    Symbol.iterator in Object(iter) ||
    Object.prototype.toString.call(iter) === "[object Arguments]"
  )
    return Array.from(iter);
}

function _arrayWithoutHoles(arr) {
  if (Array.isArray(arr)) {
    for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++)
      arr2[i] = arr[i];
    return arr2;
  }
}

const getSourceMapInfo = require("./helpers/getSourceMapInfo");

const _require = require("./helpers/js"),
  isJsModule = _require.isJsModule;

const _require2 = require("metro-source-map"),
  fromRawMappings = _require2.fromRawMappings;

function fullSourceMap(pre, graph, options) {
  const modules = _toConsumableArray(pre)
    .concat(_toConsumableArray(graph.dependencies.values()))
    .filter(isJsModule)
    .filter(options.processModuleFilter)
    .map(module =>
      getSourceMapInfo(module, {
        excludeSource: options.excludeSource
      })
    );

  return fromRawMappings(modules).toString(undefined, {
    excludeSource: options.excludeSource
  });
}

module.exports = fullSourceMap;
