/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *
 * @format
 */
"use strict";

function _toConsumableArray(arr) {
  return (
    _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread()
  );
}

function _nonIterableSpread() {
  throw new TypeError("Invalid attempt to spread non-iterable instance");
}

function _iterableToArray(iter) {
  if (
    Symbol.iterator in Object(iter) ||
    Object.prototype.toString.call(iter) === "[object Arguments]"
  )
    return Array.from(iter);
}

function _arrayWithoutHoles(arr) {
  if (Array.isArray(arr)) {
    for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++)
      arr2[i] = arr[i];
    return arr2;
  }
}

const getAppendScripts = require("../../lib/getAppendScripts");

const _require = require("./helpers/js"),
  wrapModule = _require.wrapModule;

const _require2 = require("./helpers/js"),
  getJsOutput = _require2.getJsOutput,
  isJsModule = _require2.isJsModule;

function deltaJSBundle(entryPoint, pre, delta, revisionId, graph, options) {
  const processModuleFilter = options.processModuleFilter;

  const modules = _toConsumableArray(delta.modified.values())
    .filter(isJsModule)
    .filter(processModuleFilter)
    .map(module => [
      options.createModuleId(module.path),
      wrapModule(module, options)
    ]);

  if (delta.reset) {
    const appendScripts = getAppendScripts(entryPoint, pre, graph, options);
    return {
      base: true,
      revisionId,
      pre: pre
        .filter(isJsModule)
        .filter(processModuleFilter)
        .map(module => getJsOutput(module).data.code)
        .join("\n"),
      post: appendScripts
        .filter(isJsModule)
        .filter(processModuleFilter)
        .map(module => getJsOutput(module).data.code)
        .join("\n"),
      modules
    };
  }

  return {
    base: false,
    revisionId,
    modules,
    deleted: _toConsumableArray(delta.deleted).map(path =>
      options.createModuleId(path)
    )
  };
}

module.exports = deltaJSBundle;
