'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports.default = withNavigationFocus;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _hoistNonReactStatics = require('hoist-non-react-statics');

var _hoistNonReactStatics2 = _interopRequireDefault(_hoistNonReactStatics);

var _withNavigation = require('./withNavigation');

var _withNavigation2 = _interopRequireDefault(_withNavigation);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function withNavigationFocus(Component) {
  class ComponentWithNavigationFocus extends _react2.default.Component {

    constructor(props) {
      super(props);

      this.state = {
        isFocused: props.navigation ? props.navigation.isFocused() : false
      };
    }

    componentDidMount() {
      var { navigation } = this.props;
      this.subscriptions = [navigation.addListener('didFocus', () => this.setState({ isFocused: true })), navigation.addListener('willBlur', () => this.setState({ isFocused: false }))];
    }

    componentWillUnmount() {
      this.subscriptions.forEach(sub => sub.remove());
    }

    render() {
      return _react2.default.createElement(Component, _extends({}, this.props, {
        isFocused: this.state.isFocused,
        ref: this.props.onRef
      }));
    }
  }

  ComponentWithNavigationFocus.displayName = `withNavigationFocus(${Component.displayName || Component.name})`;
  return (0, _hoistNonReactStatics2.default)((0, _withNavigation2.default)(ComponentWithNavigationFocus, { forwardRef: false }), Component);
}