'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports.default = withNavigation;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _hoistNonReactStatics = require('hoist-non-react-statics');

var _hoistNonReactStatics2 = _interopRequireDefault(_hoistNonReactStatics);

var _invariant = require('../utils/invariant');

var _invariant2 = _interopRequireDefault(_invariant);

var _NavigationContext = require('./NavigationContext');

var _NavigationContext2 = _interopRequireDefault(_NavigationContext);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function withNavigation(Component, config = { forwardRef: true }) {
  class ComponentWithNavigation extends _react2.default.Component {

    render() {
      var navigationProp = this.props.navigation;
      return _react2.default.createElement(
        _NavigationContext2.default.Consumer,
        null,
        navigationContext => {
          var navigation = navigationProp || navigationContext;
          (0, _invariant2.default)(!!navigation, 'withNavigation can only be used on a view hierarchy of a navigator. The wrapped component is unable to get access to navigation from props or context.');
          return _react2.default.createElement(Component, _extends({}, this.props, {
            navigation: navigation,
            ref: config.forwardRef ? this.props.onRef : undefined
          }));
        }
      );
    }
  }

  ComponentWithNavigation.displayName = `withNavigation(${Component.displayName || Component.name})`;
  return (0, _hoistNonReactStatics2.default)(ComponentWithNavigation, Component);
}