"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

function _helperExplodeAssignableExpression() {
  const data = _interopRequireDefault(require("@babel/helper-explode-assignable-expression"));

  _helperExplodeAssignableExpression = function _helperExplodeAssignableExpression() {
    return data;
  };

  return data;
}

function t() {
  const data = _interopRequireWildcard(require("@babel/types"));

  t = function t() {
    return data;
  };

  return data;
}

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _default(opts) {
  const build = opts.build,
        operator = opts.operator;
  return {
    AssignmentExpression(path) {
      const node = path.node,
            scope = path.scope;
      if (node.operator !== operator + "=") return;
      const nodes = [];
      const exploded = (0, _helperExplodeAssignableExpression().default)(node.left, nodes, this, scope);
      nodes.push(t().assignmentExpression("=", exploded.ref, build(exploded.uid, node.right)));
      path.replaceWith(t().sequenceExpression(nodes));
    },

    BinaryExpression(path) {
      const node = path.node;

      if (node.operator === operator) {
        path.replaceWith(build(node.left, node.right));
      }
    }

  };
}