'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _withNavigation = require('./withNavigation');

var _withNavigation2 = _interopRequireDefault(_withNavigation);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var EventNameToPropName = {
  willFocus: 'onWillFocus',
  didFocus: 'onDidFocus',
  willBlur: 'onWillBlur',
  didBlur: 'onDidBlur'
};

var EventNames = Object.keys(EventNameToPropName);

class NavigationEvents extends _react2.default.Component {
  constructor(...args) {
    var _temp;

    return _temp = super(...args), this.getPropListener = eventName => this.props[EventNameToPropName[eventName]], _temp;
  }

  componentDidMount() {
    this.subscriptions = {};

    // We register all navigation listeners on mount to ensure listener stability across re-render
    // A former implementation was replacing (removing/adding) listeners on all update (if prop provided)
    // but there were issues (see https://github.com/react-navigation/react-navigation/issues/5058)
    EventNames.forEach(eventName => {
      this.subscriptions[eventName] = this.props.navigation.addListener(eventName, (...args) => {
        var propListener = this.getPropListener(eventName);
        return propListener && propListener(...args);
      });
    });
  }

  componentWillUnmount() {
    EventNames.forEach(eventName => {
      this.subscriptions[eventName].remove();
    });
  }

  render() {
    return null;
  }
}

exports.default = (0, _withNavigation2.default)(NavigationEvents);