'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _invariant = require('../utils/invariant');

var _invariant2 = _interopRequireDefault(_invariant);

var _getScreenForRouteName = require('./getScreenForRouteName');

var _getScreenForRouteName2 = _interopRequireDefault(_getScreenForRouteName);

var _validateScreenOptions = require('./validateScreenOptions');

var _validateScreenOptions2 = _interopRequireDefault(_validateScreenOptions);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function applyConfig(configurer, navigationOptions, configProps) {
  if (typeof configurer === 'function') {
    return _extends({}, navigationOptions, configurer(_extends({}, configProps, {
      navigationOptions
    })));
  }
  if (typeof configurer === 'object') {
    return _extends({}, navigationOptions, configurer);
  }
  return navigationOptions;
}

exports.default = (routeConfigs, navigatorScreenConfig) => (navigation, screenProps) => {
  var { state } = navigation;
  var route = state;

  (0, _invariant2.default)(route.routeName && typeof route.routeName === 'string', 'Cannot get config because the route does not have a routeName.');

  var Component = (0, _getScreenForRouteName2.default)(routeConfigs, route.routeName);

  var routeConfig = routeConfigs[route.routeName];

  var routeScreenConfig = routeConfig === Component ? null : routeConfig.navigationOptions;
  var componentScreenConfig = Component.navigationOptions;

  var configOptions = { navigation, screenProps: screenProps || {} };

  var outputConfig = applyConfig(navigatorScreenConfig, {}, configOptions);
  outputConfig = applyConfig(componentScreenConfig, outputConfig, configOptions);
  outputConfig = applyConfig(routeScreenConfig, outputConfig, configOptions);

  (0, _validateScreenOptions2.default)(outputConfig, route);

  return outputConfig;
};