'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports.default = getNavigation;

var _getNavigationActionCreators = require('./routers/getNavigationActionCreators');

var _getNavigationActionCreators2 = _interopRequireDefault(_getNavigationActionCreators);

var _getChildNavigation = require('./getChildNavigation');

var _getChildNavigation2 = _interopRequireDefault(_getChildNavigation);

var _getChildrenNavigationCache = require('./getChildrenNavigationCache');

var _getChildrenNavigationCache2 = _interopRequireDefault(_getChildrenNavigationCache);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function getNavigation(router, state, dispatch, actionSubscribers, getScreenProps, getCurrentNavigation) {
  var actions = router.getActionCreators(state, null);

  var navigation = {
    actions,
    router,
    state,
    dispatch,
    getScreenProps,
    getChildNavigation: childKey => (0, _getChildNavigation2.default)(navigation, childKey, getCurrentNavigation),
    isFocused: childKey => {
      var { routes, index } = getCurrentNavigation().state;
      if (childKey == null || routes[index].key === childKey) {
        return true;
      }
      return false;
    },
    addListener: (eventName, handler) => {
      if (eventName !== 'action') {
        return { remove: () => {} };
      }
      actionSubscribers.add(handler);
      return {
        remove: () => {
          actionSubscribers.delete(handler);
        }
      };
    },
    dangerouslyGetParent: () => null,
    _childrenNavigation: (0, _getChildrenNavigationCache2.default)(getCurrentNavigation())
  };

  var actionCreators = _extends({}, (0, _getNavigationActionCreators2.default)(navigation.state), actions);

  Object.keys(actionCreators).forEach(actionName => {
    navigation[actionName] = (...args) => navigation.dispatch(actionCreators[actionName](...args));
  });

  return navigation;
}