<p align="center">
  <a href="https://react-native-training.github.io/react-native-elements/">
    <img alt="react-native-elements" src="https://user-images.githubusercontent.com/5962998/37248835-ce3dad4a-24b1-11e8-9c4b-b058c5a5e1e9.png" width="450">
  </a>
</p>

<h3 align="center">
  React Native Elements
</h3>

<p align="center">
  Cross Platform <a href="https://facebook.github.io/react-native/">React Native</a> UI Toolkit
</p>

<p align="center">
  <a href="https://www.npmjs.com/package/react-native-elements"><img src="https://img.shields.io/npm/v/react-native-elements.svg?style=flat-square"></a>
  <a href="https://www.npmjs.com/package/react-native-elements"><img src="https://img.shields.io/npm/dm/react-native-elements.svg?style=flat-square"></a>
  <a href="https://travis-ci.org/react-native-training/react-native-elements"><img src="https://img.shields.io/travis/react-native-training/react-native-elements/master.svg?style=flat-square"></a>
  <a href="https://reactnativetraining.herokuapp.com/"><img src="https://reactnativetraining.herokuapp.com/badge.svg"></a>
</p>

<p align="center">
  <a href="#backers"><img src="https://opencollective.com/react-native-elements/backers/badge.svg"></a>
  <a href="#sponsors"><img src="https://opencollective.com/react-native-elements/sponsors/badge.svg"></a>
  <a href="https://codecov.io/gh/react-native-training/react-native-elements"><img src="https://codecov.io/gh/react-native-training/react-native-elements/coverage.svg"></a>
  <a href="https://github.com/prettier/prettier"><img src="https://img.shields.io/badge/styled_with-prettier-ff69b4.svg"></a>
  <a href="https://opensource.org/licenses/MIT"><img src="https://img.shields.io/badge/License-MIT-blue.svg"></a>
</p>

<br />

![React Native Elements UI Toolkit](https://user-images.githubusercontent.com/5962998/37248832-a7060286-24b1-11e8-94a8-847ab6ded4ec.png)

## Get Started

### Installation

Follow
[these instructions](https://react-native-training.github.io/react-native-elements/docs/getting_started.html)
to install React Native Elements!

### Usage

Start using the components or try it on Snack
[here](https://snack.expo.io/rJu6gJfBZ).

```js
import { Button } from 'react-native-elements';

<Button />;
```

## Components included:

- [x] [Avatar](https://react-native-training.github.io/react-native-elements/docs/avatar.html)
- [x] [Badge](https://react-native-training.github.io/react-native-elements/docs/badge.html)
- [x] [Button](https://react-native-training.github.io/react-native-elements/docs/button.html)
- [x] [ButtonGroup](https://react-native-training.github.io/react-native-elements/docs/button_group.html)
- [x] [Card](https://react-native-training.github.io/react-native-elements/docs/card.html)
- [x] [CheckBox](https://react-native-training.github.io/react-native-elements/docs/checkbox.html)
- [x] [Divider](https://react-native-training.github.io/react-native-elements/docs/divider.html)
- [x] [Header](https://react-native-training.github.io/react-native-elements/docs/header.html)
- [x] [HTML style headings](https://react-native-training.github.io/react-native-elements/docs/text.html)
- [x] [Icon](https://react-native-training.github.io/react-native-elements/docs/icon.html)
- [x] [Image](https://react-native-training.github.io/react-native-elements/docs/image.html)
- [x] [Input](https://react-native-training.github.io/react-native-elements/docs/input.html)
- [x] [ListItem](https://react-native-training.github.io/react-native-elements/docs/listitem.html)
- [x] [Overlay](https://react-native-training.github.io/react-native-elements/docs/overlay.html)
- [x] [Pricing](https://react-native-training.github.io/react-native-elements/docs/pricing.html)
- [x] [Rating](https://react-native-training.github.io/react-native-elements/docs/rating.html)
- [x] [SearchBar](https://react-native-training.github.io/react-native-elements/docs/searchbar.html)
- [x] [Slider](https://react-native-training.github.io/react-native-elements/docs/slider.html)
- [x] [Social Icons / Social Icon Buttons](https://react-native-training.github.io/react-native-elements/docs/social_icon.html)
- [x] [Tile](https://react-native-training.github.io/react-native-elements/docs/tile.html)
- [x] [Tooltip](https://react-native-training.github.io/react-native-elements/docs/tooltip.html)

## RNE Ecosystem:

React Native Elements also serves as a **platform** that connects **small
teams/individuals** that needs help developing their RN app with **open source
contributors** that are willing to **build complex UI screens & animated
interactions** for 💰💰💰.

Here are some of the screens that our developers have created so far:

<div style="display: flex; flex-direction: row; margin-bottom: 50px">
  <img src="https://user-images.githubusercontent.com/7840686/32702785-b1d9114e-c7a0-11e7-9999-6c6a00d432ec.gif" width="280" />
  <img src="https://user-images.githubusercontent.com/7840686/32702789-b6bbdce6-c7a0-11e7-8034-8144274fbdae.gif" width="280" />
  <img src="https://user-images.githubusercontent.com/7840686/32702791-b947eedc-c7a0-11e7-8e8c-7dff1bd80564.gif" width="280" />
</div>
<br /><br />

If this sounds interesting and you would like to participate, kindly open a
**new issue with the design & spec of the UI screen** that you need to be
developed. One of our developers will respond to your issue with an estimate of
time & cost.

It's built on top of **RNE & Open Collective**. If you have any feedback or
would like to know more details about this kindly contact
**[Monte Thakkar](https://github.com/Monte9)**.

## React Native Web support

As a cross platform UI Toolkit, you can now use RNE on the web & share your codebase between your React Native + React web apps. RNE components are rendered perfectly on browser. You can achieve this to target iOS, Android and Web by collaborating RNE and [React Native for Web](https://github.com/necolas/react-native-web).

Click [here](https://react-native-training.github.io/react-native-elements/blog/2018/12/13/react-native-web.html) for a full walkthrough using React Native Elements + React Native Web.

## Expo Demo App

Checkout the official
[React Native Elements App](https://expo.io/@monte9/react-native-elements-app)
on Expo which uses all of the React Native Elements components.

If you are looking to contribute to the React Native Elements App, click
[here](https://github.com/react-native-training/react-native-elements-app) to
view the implementation & run the RNE expo app locally.

## Documentation

[View the full docs here](https://react-native-training.github.io/react-native-elements/docs/overview.html)

## Contributing

Interested in contributing to this repo? Check out our
[Contributing Guide](https://react-native-training.github.io/react-native-elements/docs/contributing.html)
and submit a PR for a new feature/bug fix.

A big shoutout to all our contributors! You could be here too!

<a href="https://github.com/react-native-training/react-native-elements/graphs/contributors"><img src="https://opencollective.com/react-native-elements/contributors.svg?width=890&button=false" /></a>

### First Contributors

We encourage everyone to contribute & submit PR's especially first-time
contributors. Look for the label `Good First Issue` on the issues. Click
[here](https://github.com/react-native-training/react-native-elements/labels/Good%20First%20Issue)
to see them.

If there is something you's like to see or request a new feature, please submit
an
[issue](https://github.com/react-native-training/react-native-elements/issues/new)
or a
[pull request](https://github.com/react-native-training/react-native-elements/pulls).

### Slack Community

In case you have any other question or would like to come say **Hi!** to the RNE
community, join our [Slack team](https://reactnativetraining.herokuapp.com/).
See you on the other side! 👋😃

## Backers

Support us with a monthly donation and help us continue our activities.
[[Become a backer](https://opencollective.com/react-native-elements#backer)]

<a href="https://opencollective.com/react-native-elements#backers" target="_blank"><img src="https://opencollective.com/react-native-elements/backers.svg?width=890"></a>


## Sponsors

Become a sponsor and get your logo on our README on Github with a link to your
site.
[[Become a sponsor](https://opencollective.com/react-native-elements#sponsor)]

<a href="https://opencollective.com/react-native-elements#sponsors" target="_blank"><img src="https://opencollective.com/react-native-elements/sponsors.svg?width=890"></a>
