/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @emails oncall+javascript_foundation
 * @format
 */

"use strict";
function _asyncToGenerator(fn) {
  return function() {
    var gen = fn.apply(this, arguments);
    return new Promise(function(resolve, reject) {
      function step(key, arg) {
        try {
          var info = gen[key](arg);
          var value = info.value;
        } catch (error) {
          reject(error);
          return;
        }
        if (info.done) {
          resolve(value);
        } else {
          return Promise.resolve(value).then(
            function(value) {
              step("next", value);
            },
            function(err) {
              step("throw", err);
            }
          );
        }
      }
      return step("next");
    });
  };
}

const path = require("path");

const ROOT_PATH = path.resolve(__dirname, "basic_bundle");

module.exports = {
  cacheStores: [],
  maxWorkers: 1,
  projectRoot: ROOT_PATH,
  reporter: { update() {} },
  watchFolders: [path.resolve(__dirname, "../lib/polyfills")],
  server: { port: 10028 },
  resolver: {
    useWatchman: false
  },

  transformer: {
    assetRegistryPath: path.join(ROOT_PATH, "AssetRegistry"),
    babelTransformerPath: require.resolve("metro/src/reactNativeTransformer"),
    enableBabelRCLookup: false,
    enableBabelRuntime: false,
    getTransformOptions: (() => {
      var _ref = _asyncToGenerator(function*() {
        return {
          transform: { experimentalImportSupport: true, inlineRequires: false },
          preloadedModules: false,
          ramGroups: []
        };
      });
      return function getTransformOptions() {
        return _ref.apply(this, arguments);
      };
    })()
  }
};
