/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *  strict-local
 * @format
 */

"use strict";
var _extends =
  Object.assign ||
  function(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }
    return target;
  };

const uglify = require("uglify-es");

function minifier(options) {
  const result = minify(options);

  if (!options.map || result.map == null) {
    return { code: result.code };
  }

  const map = JSON.parse(result.map);
  map.sources = [options.filename];

  return { code: result.code, map };
}

function minify(_ref) {
  let code = _ref.code,
    map = _ref.map,
    reserved = _ref.reserved,
    config = _ref.config;
  const options = _extends({}, config, {
    mangle: _extends({}, config.mangle, {
      reserved
    }),

    sourceMap: _extends({}, config.sourceMap, {
      content: map
    })
  });

  const result = uglify.minify(code, options);

  if (result.error) {
    throw result.error;
  }

  return {
    code: result.code,
    // eslint-disable-next-line lint/flow-no-fixme
    // $FlowFixMe flow cannot coerce the uglify options after using spread.
    map: result.map
  };
}

module.exports = minifier;
