"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

function _helperPluginUtils() {
  const data = require("@babel/helper-plugin-utils");

  _helperPluginUtils = function _helperPluginUtils() {
    return data;
  };

  return data;
}

function _pluginSyntaxObjectRestSpread() {
  const data = _interopRequireDefault(require("@babel/plugin-syntax-object-rest-spread"));

  _pluginSyntaxObjectRestSpread = function _pluginSyntaxObjectRestSpread() {
    return data;
  };

  return data;
}

function _core() {
  const data = require("@babel/core");

  _core = function _core() {
    return data;
  };

  return data;
}

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _default = (0, _helperPluginUtils().declare)((api, opts) => {
  api.assertVersion(7);
  const _opts$useBuiltIns = opts.useBuiltIns,
        useBuiltIns = _opts$useBuiltIns === void 0 ? false : _opts$useBuiltIns,
        _opts$loose = opts.loose,
        loose = _opts$loose === void 0 ? false : _opts$loose;

  if (typeof loose !== "boolean") {
    throw new Error(".loose must be a boolean, or undefined");
  }

  function getExtendsHelper(file) {
    return useBuiltIns ? _core().types.memberExpression(_core().types.identifier("Object"), _core().types.identifier("assign")) : file.addHelper("extends");
  }

  function hasRestElement(path) {
    let foundRestElement = false;
    visitRestElements(path, () => {
      foundRestElement = true;
      path.stop();
    });
    return foundRestElement;
  }

  function visitRestElements(path, visitor) {
    path.traverse({
      Expression(path) {
        const parentType = path.parent.type;

        if (parentType == "AssignmentPattern" && path.key === "right" || parentType == "ObjectProperty" && path.parent.computed && path.key === "key") {
          path.skip();
        }
      },

      RestElement: visitor
    });
  }

  function hasSpread(node) {
    for (var _iterator = node.properties, _isArray = Array.isArray(_iterator), _i = 0, _iterator = _isArray ? _iterator : _iterator[Symbol.iterator]();;) {
      var _ref;

      if (_isArray) {
        if (_i >= _iterator.length) break;
        _ref = _iterator[_i++];
      } else {
        _i = _iterator.next();
        if (_i.done) break;
        _ref = _i.value;
      }

      const prop = _ref;

      if (_core().types.isSpreadElement(prop)) {
        return true;
      }
    }

    return false;
  }

  function extractNormalizedKeys(path) {
    const props = path.node.properties;
    const keys = [];
    let allLiteral = true;

    for (var _iterator2 = props, _isArray2 = Array.isArray(_iterator2), _i2 = 0, _iterator2 = _isArray2 ? _iterator2 : _iterator2[Symbol.iterator]();;) {
      var _ref2;

      if (_isArray2) {
        if (_i2 >= _iterator2.length) break;
        _ref2 = _iterator2[_i2++];
      } else {
        _i2 = _iterator2.next();
        if (_i2.done) break;
        _ref2 = _i2.value;
      }

      const prop = _ref2;

      if (_core().types.isIdentifier(prop.key) && !prop.computed) {
        keys.push(_core().types.stringLiteral(prop.key.name));
      } else if (_core().types.isLiteral(prop.key)) {
        keys.push(_core().types.stringLiteral(String(prop.key.value)));
      } else {
        keys.push(_core().types.cloneNode(prop.key));
        allLiteral = false;
      }
    }

    return {
      keys,
      allLiteral
    };
  }

  function replaceImpureComputedKeys(path) {
    const impureComputedPropertyDeclarators = [];

    for (var _iterator3 = path.get("properties"), _isArray3 = Array.isArray(_iterator3), _i3 = 0, _iterator3 = _isArray3 ? _iterator3 : _iterator3[Symbol.iterator]();;) {
      var _ref3;

      if (_isArray3) {
        if (_i3 >= _iterator3.length) break;
        _ref3 = _iterator3[_i3++];
      } else {
        _i3 = _iterator3.next();
        if (_i3.done) break;
        _ref3 = _i3.value;
      }

      const propPath = _ref3;
      const key = propPath.get("key");

      if (propPath.node.computed && !key.isPure()) {
        const name = path.scope.generateUidBasedOnNode(key.node);

        const declarator = _core().types.variableDeclarator(_core().types.identifier(name), key.node);

        impureComputedPropertyDeclarators.push(declarator);
        key.replaceWith(_core().types.identifier(name));
      }
    }

    return impureComputedPropertyDeclarators;
  }

  function createObjectSpread(path, file, objRef) {
    const props = path.get("properties");
    const last = props[props.length - 1];

    _core().types.assertRestElement(last.node);

    const restElement = _core().types.cloneNode(last.node);

    last.remove();
    const impureComputedPropertyDeclarators = replaceImpureComputedKeys(path);

    const _extractNormalizedKey = extractNormalizedKeys(path),
          keys = _extractNormalizedKey.keys,
          allLiteral = _extractNormalizedKey.allLiteral;

    if (keys.length === 0) {
      return [impureComputedPropertyDeclarators, restElement.argument, _core().types.callExpression(getExtendsHelper(file), [_core().types.objectExpression([]), _core().types.cloneNode(objRef)])];
    }

    let keyExpression;

    if (!allLiteral) {
      keyExpression = _core().types.callExpression(_core().types.memberExpression(_core().types.arrayExpression(keys), _core().types.identifier("map")), [file.addHelper("toPropertyKey")]);
    } else {
      keyExpression = _core().types.arrayExpression(keys);
    }

    return [impureComputedPropertyDeclarators, restElement.argument, _core().types.callExpression(file.addHelper("objectWithoutProperties"), [_core().types.cloneNode(objRef), keyExpression])];
  }

  function replaceRestElement(parentPath, paramPath, i, numParams) {
    if (paramPath.isAssignmentPattern()) {
      replaceRestElement(parentPath, paramPath.get("left"), i, numParams);
      return;
    }

    if (paramPath.isArrayPattern() && hasRestElement(paramPath)) {
      const elements = paramPath.get("elements");

      for (let i = 0; i < elements.length; i++) {
        replaceRestElement(parentPath, elements[i], i, elements.length);
      }
    }

    if (paramPath.isObjectPattern() && hasRestElement(paramPath)) {
      const uid = parentPath.scope.generateUidIdentifier("ref");

      const declar = _core().types.variableDeclaration("let", [_core().types.variableDeclarator(paramPath.node, uid)]);

      parentPath.ensureBlock();
      parentPath.get("body").unshiftContainer("body", declar);
      paramPath.replaceWith(_core().types.cloneNode(uid));
    }
  }

  return {
    inherits: _pluginSyntaxObjectRestSpread().default,
    visitor: {
      Function(path) {
        const params = path.get("params");

        for (let i = params.length - 1; i >= 0; i--) {
          replaceRestElement(params[i].parentPath, params[i], i, params.length);
        }
      },

      VariableDeclarator(path, file) {
        if (!path.get("id").isObjectPattern()) {
          return;
        }

        let insertionPath = path;
        const originalPath = path;
        visitRestElements(path.get("id"), path => {
          if (!path.parentPath.isObjectPattern()) {
            return;
          }

          if (originalPath.node.id.properties.length > 1 && !_core().types.isIdentifier(originalPath.node.init)) {
            const initRef = path.scope.generateUidIdentifierBasedOnNode(originalPath.node.init, "ref");
            originalPath.insertBefore(_core().types.variableDeclarator(initRef, originalPath.node.init));
            originalPath.replaceWith(_core().types.variableDeclarator(originalPath.node.id, _core().types.cloneNode(initRef)));
            return;
          }

          let ref = originalPath.node.init;
          const refPropertyPath = [];
          let kind;
          path.findParent(path => {
            if (path.isObjectProperty()) {
              refPropertyPath.unshift(path.node.key.name);
            } else if (path.isVariableDeclarator()) {
              kind = path.parentPath.node.kind;
              return true;
            }
          });

          if (refPropertyPath.length) {
            refPropertyPath.forEach(prop => {
              ref = _core().types.memberExpression(ref, _core().types.identifier(prop));
            });
          }

          const objectPatternPath = path.findParent(path => path.isObjectPattern());

          const _createObjectSpread = createObjectSpread(objectPatternPath, file, ref),
                impureComputedPropertyDeclarators = _createObjectSpread[0],
                argument = _createObjectSpread[1],
                callExpression = _createObjectSpread[2];

          _core().types.assertIdentifier(argument);

          insertionPath.insertBefore(impureComputedPropertyDeclarators);
          insertionPath.insertAfter(_core().types.variableDeclarator(argument, callExpression));
          insertionPath = insertionPath.getSibling(insertionPath.key + 1);
          path.scope.registerBinding(kind, insertionPath);

          if (objectPatternPath.node.properties.length === 0) {
            objectPatternPath.findParent(path => path.isObjectProperty() || path.isVariableDeclarator()).remove();
          }
        });
      },

      ExportNamedDeclaration(path) {
        const declaration = path.get("declaration");
        if (!declaration.isVariableDeclaration()) return;
        const hasRest = declaration.get("declarations").some(path => hasRestElement(path.get("id")));
        if (!hasRest) return;
        const specifiers = [];

        for (const name in path.getOuterBindingIdentifiers(path)) {
          specifiers.push(_core().types.exportSpecifier(_core().types.identifier(name), _core().types.identifier(name)));
        }

        path.replaceWith(declaration.node);
        path.insertAfter(_core().types.exportNamedDeclaration(null, specifiers));
      },

      CatchClause(path) {
        const paramPath = path.get("param");
        replaceRestElement(paramPath.parentPath, paramPath);
      },

      AssignmentExpression(path, file) {
        const leftPath = path.get("left");

        if (leftPath.isObjectPattern() && hasRestElement(leftPath)) {
          const nodes = [];
          const refName = path.scope.generateUidBasedOnNode(path.node.right, "ref");
          nodes.push(_core().types.variableDeclaration("var", [_core().types.variableDeclarator(_core().types.identifier(refName), path.node.right)]));

          const _createObjectSpread2 = createObjectSpread(leftPath, file, _core().types.identifier(refName)),
                impureComputedPropertyDeclarators = _createObjectSpread2[0],
                argument = _createObjectSpread2[1],
                callExpression = _createObjectSpread2[2];

          if (impureComputedPropertyDeclarators.length > 0) {
            nodes.push(_core().types.variableDeclaration("var", impureComputedPropertyDeclarators));
          }

          const nodeWithoutSpread = _core().types.cloneNode(path.node);

          nodeWithoutSpread.right = _core().types.identifier(refName);
          nodes.push(_core().types.expressionStatement(nodeWithoutSpread));
          nodes.push(_core().types.toStatement(_core().types.assignmentExpression("=", argument, callExpression)));
          nodes.push(_core().types.expressionStatement(_core().types.identifier(refName)));
          path.replaceWithMultiple(nodes);
        }
      },

      ForXStatement(path) {
        const node = path.node,
              scope = path.scope;
        const leftPath = path.get("left");
        const left = node.left;

        if (_core().types.isObjectPattern(left) && hasRestElement(leftPath)) {
          const temp = scope.generateUidIdentifier("ref");
          node.left = _core().types.variableDeclaration("var", [_core().types.variableDeclarator(temp)]);
          path.ensureBlock();
          node.body.body.unshift(_core().types.variableDeclaration("var", [_core().types.variableDeclarator(left, _core().types.cloneNode(temp))]));
          return;
        }

        if (!_core().types.isVariableDeclaration(left)) return;
        const pattern = left.declarations[0].id;
        if (!_core().types.isObjectPattern(pattern)) return;
        const key = scope.generateUidIdentifier("ref");
        node.left = _core().types.variableDeclaration(left.kind, [_core().types.variableDeclarator(key, null)]);
        path.ensureBlock();
        node.body.body.unshift(_core().types.variableDeclaration(node.left.kind, [_core().types.variableDeclarator(pattern, _core().types.cloneNode(key))]));
      },

      ObjectExpression(path, file) {
        if (!hasSpread(path.node)) return;
        const args = [];
        let props = [];

        function push() {
          if (!props.length) return;
          args.push(_core().types.objectExpression(props));
          props = [];
        }

        if (_core().types.isSpreadElement(path.node.properties[0])) {
          args.push(_core().types.objectExpression([]));
        }

        var _arr = path.node.properties;

        for (var _i4 = 0; _i4 < _arr.length; _i4++) {
          const prop = _arr[_i4];

          if (_core().types.isSpreadElement(prop)) {
            push();
            args.push(prop.argument);
          } else {
            props.push(prop);
          }
        }

        push();
        let helper;

        if (loose) {
          helper = getExtendsHelper(file);
        } else {
          helper = file.addHelper("objectSpread");
        }

        path.replaceWith(_core().types.callExpression(helper, args));
      }

    }
  };
});

exports.default = _default;