'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var POP = 'Navigation/POP';
var POP_TO_TOP = 'Navigation/POP_TO_TOP';
var PUSH = 'Navigation/PUSH';
var RESET = 'Navigation/RESET';
var REPLACE = 'Navigation/REPLACE';
var COMPLETE_TRANSITION = 'Navigation/COMPLETE_TRANSITION';

var pop = payload => _extends({
  type: POP
}, payload);

var popToTop = payload => _extends({
  type: POP_TO_TOP
}, payload);

var push = payload => _extends({
  type: PUSH
}, payload);

var reset = payload => _extends({
  type: RESET
}, payload);

var replace = payload => _extends({
  type: REPLACE
}, payload);

var completeTransition = payload => _extends({
  type: COMPLETE_TRANSITION
}, payload);

exports.default = {
  POP,
  POP_TO_TOP,
  PUSH,
  RESET,
  REPLACE,
  COMPLETE_TRANSITION,

  pop,
  popToTop,
  push,
  reset,
  replace,
  completeTransition
};