'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactLifecyclesCompat = require('react-lifecycles-compat');

var _invariant = require('../utils/invariant');

var _invariant2 = _interopRequireDefault(_invariant);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function createNavigator(NavigatorView, router, navigationConfig) {
  class Navigator extends _react2.default.Component {
    constructor(...args) {
      var _temp;

      return _temp = super(...args), this.state = {
        descriptors: {},
        screenProps: this.props.screenProps
      }, _temp;
    }

    static getDerivedStateFromProps(nextProps, prevState) {
      var prevDescriptors = prevState.descriptors;
      var { navigation, screenProps } = nextProps;
      (0, _invariant2.default)(navigation != null, 'The navigation prop is missing for this navigator. In react-navigation 3 you must set up your app container directly. More info: https://reactnavigation.org/docs/en/app-containers.html');
      var { state } = navigation;
      var { routes } = state;
      if (typeof routes === 'undefined') {
        throw new TypeError('No "routes" found in navigation state. Did you try to pass the navigation prop of a React component to a Navigator child? See https://reactnavigation.org/docs/en/custom-navigators.html#navigator-navigation-prop');
      }

      var descriptors = {};

      routes.forEach(route => {
        if (prevDescriptors && prevDescriptors[route.key] && route === prevDescriptors[route.key].state && screenProps === prevState.screenProps) {
          descriptors[route.key] = prevDescriptors[route.key];
          return;
        }
        var getComponent = router.getComponentForRouteName.bind(null, route.routeName);
        var childNavigation = navigation.getChildNavigation(route.key);
        var options = router.getScreenOptions(childNavigation, screenProps);
        descriptors[route.key] = {
          key: route.key,
          getComponent,
          options,
          state: route,
          navigation: childNavigation
        };
      });

      return { descriptors, screenProps };
    }

    render() {
      return _react2.default.createElement(NavigatorView, _extends({}, this.props, {
        screenProps: this.state.screenProps,
        navigation: this.props.navigation,
        navigationConfig: navigationConfig,
        descriptors: this.state.descriptors
      }));
    }
  }

  Navigator.router = router;
  Navigator.navigationOptions = navigationConfig.navigationOptions;
  return (0, _reactLifecyclesCompat.polyfill)(Navigator);
}

exports.default = createNavigator;