'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
var BACK = 'Navigation/BACK';
var INIT = 'Navigation/INIT';
var NAVIGATE = 'Navigation/NAVIGATE';
var SET_PARAMS = 'Navigation/SET_PARAMS';

var back = (payload = {}) => ({
  type: BACK,
  key: payload.key,
  immediate: payload.immediate
});

var init = (payload = {}) => {
  var action = {
    type: INIT
  };
  if (payload.params) {
    action.params = payload.params;
  }
  return action;
};

var navigate = payload => {
  var action = {
    type: NAVIGATE,
    routeName: payload.routeName
  };
  if (payload.params) {
    action.params = payload.params;
  }
  if (payload.action) {
    action.action = payload.action;
  }
  if (payload.key) {
    action.key = payload.key;
  }
  return action;
};

var setParams = payload => ({
  type: SET_PARAMS,
  key: payload.key,
  params: payload.params
});

exports.default = {
  // Action constants
  BACK,
  INIT,
  NAVIGATE,
  SET_PARAMS,

  // Action creators
  back,
  init,
  navigate,
  setParams
};