package de.k4ever.k4android.utils;

import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Paint.Style;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;

public class BouncingArrow extends View {
	float _currentX = 10;
	Paint paint;
	private ObjectAnimator mAnimator;
	final int width = 100;

	public BouncingArrow(Context context, AttributeSet attrs) {
		super(context, attrs);
		init();
		this.setVisibility(VISIBLE);
	}

	private void init() {

		paint = new Paint();
		mAnimator = ObjectAnimator.ofInt(this, "X", 100, 300);
		mAnimator.setInterpolator(new AccelerateDecelerateInterpolator());
		mAnimator.setDuration(3000);
		mAnimator.setRepeatCount(ValueAnimator.INFINITE);
		mAnimator.setRepeatMode(ValueAnimator.REVERSE);

		mAnimator.start();
	}
	
    public void setX(int value) {
    	_currentX = value;
    	invalidate();
    }
    public float getX() {
        return _currentX;
    }


	@Override
	protected void onDraw(Canvas canvas) {
		final int middleY = getHeight()/2;
		paint.setColor(Color.CYAN);
		paint.setStrokeWidth(20);
		paint.setStyle(Style.FILL);
		canvas.drawLine(_currentX, middleY, _currentX + width, middleY, paint);
	}
}
