package de.k4ever.k4android.fragments;

import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.CursorLoader;
import android.support.v4.widget.SwipeRefreshLayout;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import de.k4ever.k4android.utils.KassenHttpUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import android.app.ProgressDialog;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.view.ActionMode;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.ListView;
import android.widget.Toast;
import de.k4ever.k4android.BalanceActivity;
import de.k4ever.k4android.BuyScreenActivity;
import de.k4ever.k4android.HistoryListActivity;
import de.k4ever.k4android.PreferencesActivity;
import de.k4ever.k4android.R;
import de.k4ever.k4android.VirtualsActivity;
import de.k4ever.k4android.database.KassenContentProvider;
import de.k4ever.k4android.database.KassenSQLiteHelper.Products;
import de.k4ever.k4android.database.KassenUpdateDatasets;
import de.k4ever.k4android.database.KassenUpdateDatasets.RequestType;
import de.k4ever.k4android.utils.KassenConfig;
import de.k4ever.k4android.utils.KassenListeAdapter;
import de.k4ever.k4android.utils.KassenUtils;

public class ProdukteFragment extends SwipeRefreshListFragment
        implements LoaderManager.LoaderCallbacks<Cursor> {
    private KassenListeAdapter mAdapter;
    protected Boolean mReady = true;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    public void onDetach() {
        super.onDetach();
        mReady = false;
    }

    @Override
    public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
        inflater.inflate(R.menu.produkte_menu, menu);
    }

    @Override
    public boolean onOptionsItemSelected(final MenuItem item) {
        Intent intent;

        switch(item.getItemId()) {
            case R.id.menu_settings:
                intent = new Intent(getActivity(),
                        PreferencesActivity.class);
                startActivity(intent);
                break;
            case R.id.menu_virtuals:
                intent = new Intent(getActivity(),
                        VirtualsActivity.class);
                startActivity(intent);
                break;
            case R.id.menu_history:
                intent = new Intent(getActivity(),
                        HistoryListActivity.class);
                startActivity(intent);
                break;
            case R.id.menu_balance:
                intent = new Intent(getActivity(),
                        BalanceActivity.class);
                startActivity(intent);
                break;
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);

        setHasOptionsMenu(true);
        setEmptyText(getText(R.string.products_empty));
        mReady = true;

        mAdapter = new KassenListeAdapter(getActivity(), null ,0);
        setListAdapter(mAdapter);
        setListShown(false);

        getListView().setChoiceMode(ListView.CHOICE_MODE_MULTIPLE_MODAL);
        getListView().setMultiChoiceModeListener(new ModeCallback());

        setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener() {
            @Override
            public void onRefresh() {
                if (!isRefreshing()) {
                    setRefreshing(true);
                }

                new KassenUpdateDatasets(getActivity()) {
                    @Override
                    protected void onPostExecute(Void result) {
                        super.onPostExecute(result);

                        setRefreshing(false);
                    }
                }.execute(RequestType.PRODUCTS);
            }
        });


        getLoaderManager().initLoader(0, null, this);

        // when updating to version 1.1 (version code 5) we need to reset the login prefs
        final SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(getActivity());
        if (prefs.getBoolean("pref_update_to_1.1", false) == false) {
            final SharedPreferences.Editor prefEditor = prefs.edit();
            prefEditor.putBoolean("pref_loginsuccess", false);
            prefEditor.putBoolean("pref_update_to_1.1", true);
            prefEditor.apply();
        }

        if(!KassenUtils.isLoggedIn(getActivity())) {
            FragmentTransaction ft = getFragmentManager().beginTransaction();
            Fragment prev = getFragmentManager().findFragmentByTag("dialog");
            if (prev != null) {
                ft.remove(prev);
            }
            ft.addToBackStack(null);

            // Create and show the dialog.
            DialogFragment newFragment = new LoginFragment();
            newFragment.show(ft, "dialog");
        }
    }

    @Override
    public void onListItemClick(ListView l, View v, int position, long id) {
        BuyScreenFragment fragment = (BuyScreenFragment)getFragmentManager()
                .findFragmentById(R.id.fragment_buyscreen);
        if (fragment != null && fragment.isInLayout()) {
            final Cursor pCursor = mAdapter.getCursor();
            pCursor.moveToPosition(position);
            fragment.showProdukt(pCursor);
        } else {
            Intent intent = new Intent(getActivity(),
                    BuyScreenActivity.class);

            intent.putExtra("id", id);
            startActivity(intent);
        }
    }

    @Override
    public android.support.v4.content.Loader<Cursor> onCreateLoader(int id, Bundle args) {
        // Now create and return a CursorLoader that will take care of
        // creating a Cursor for the data being displayed.

        final SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(getActivity());
        final boolean sort_by_name = prefs.getBoolean("pref_sortorder", true);
        String sort = Products.COLUMN_FAVORITE + " DESC";
        if (sort_by_name) {
            sort += ", " + Products.COLUMN_NAME;
        }

        return new CursorLoader(getActivity(), KassenContentProvider.CONTENT_PRODUCTS,
                Products.COLUMNS_ALL, null, null, sort);
    }

    @Override
    public void onLoadFinished(android.support.v4.content.Loader<Cursor> loader, Cursor data) {
        mAdapter.swapCursor(data);

        // The list should now be shown.
        if (isResumed()) {
            setListShown(true);
        } else {
            setListShownNoAnimation(true);
        }
    }

    @Override
    public void onLoaderReset(android.support.v4.content.Loader<Cursor> loader) {
        mAdapter.swapCursor(null);

    }

    private class ModeCallback implements ListView.MultiChoiceModeListener {

        public boolean onCreateActionMode(ActionMode mode, Menu menu) {
            MenuInflater inflater = getActivity().getMenuInflater();
            inflater.inflate(R.menu.list_select_menu, menu);
            mode.setTitle(R.string.products_title_selection);
            setSubtitle(mode);
            return true;
        }

        public boolean onPrepareActionMode(ActionMode mode, Menu menu) {
            return true;
        }

        public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
            switch (item.getItemId()) {
                case R.id.buy:
                    JSONArray items = new JSONArray();
                    for(Long bItem: getListView().getCheckedItemIds())
                        items.put(bItem);

                    try {
                        buy((new JSONObject()).put("items", items));
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    mode.finish();
                    break;
                default:
                    Toast.makeText(getActivity(), "Clicked " + item.getTitle(),
                            Toast.LENGTH_SHORT).show();
                    break;
            }
            return true;
        }

        private void buy(JSONObject buyables) {
            String url = KassenHttpUtils.getUrl(KassenConfig.KASSEN_SUBDIR_BULKBUY, getActivity());
            JsonObjectRequest jsObjRequest = new JsonObjectRequest(Request.Method.POST, url, buyables, new Response.Listener<JSONObject>() {
                @Override
                public void onResponse(JSONObject response) {
                    try {
                        if (response != null && response.getBoolean("success")) {
                            Toast.makeText(getActivity(), getString(R.string.buy_sucess), Toast.LENGTH_LONG).show();
                        } else {
                            // JSON in error case not implemented in api
                            Toast.makeText(getActivity(), getString(R.string.buy_fail), Toast.LENGTH_LONG).show();
                        }
                    } catch (JSONException e) {
                        // no JSON result: error
                        Toast.makeText(getActivity(), getString(R.string.buy_fail), Toast.LENGTH_LONG).show();
                    }
                }
            }, new Response.ErrorListener() {
                @Override
                public void onErrorResponse(VolleyError error) {
                    Toast.makeText(getActivity(), getString(R.string.buy_fail), Toast.LENGTH_LONG).show();
                }

            });

            KassenHttpUtils.getInstance(getActivity()).addToRequestQueue(jsObjRequest);

            ProgressDialog dialog = ProgressDialog.show(getActivity(), "",
                    getString(R.string.please_wait), true);
        }

        public void onDestroyActionMode(ActionMode mode) {
        }

        public void onItemCheckedStateChanged(ActionMode mode,
                                              int position, long id, boolean checked) {
            setSubtitle(mode);
        }

        private void setSubtitle(ActionMode mode) {
            final int checkedCount = getListView().getCheckedItemCount();
            switch (checkedCount) {
                case 0:
                    mode.setSubtitle(null);
                    break;
                case 1:
                    mode.setSubtitle(R.string.products_one_selection);
                    break;
                default:
                    mode.setSubtitle("" + checkedCount + " " + getString(R.string.products_multiple_selection));
                    break;
            }
        }
    }

}
