package de.k4ever.k4android.fragments;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Map;

import android.app.Activity;
import android.util.Log;
import android.widget.*;
import com.android.volley.AuthFailureError;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import de.k4ever.k4android.utils.KassenConfig;
import de.k4ever.k4android.utils.KassenHttpUtils;
import org.json.JSONException;
import org.json.JSONObject;

import android.app.ProgressDialog;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import de.k4ever.k4android.R;

public class ManageBalanceFragment extends Fragment {
	private Menu balanceMenu;
	private Switch withDraw;
	private EditText mSum;
	private Double mBalance;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		mBalance = Double.NaN;
	}

	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container,
			Bundle savedInstanceState) {
		View view = inflater.inflate(R.layout.layout_manage_balance, container, false);

		mSum = (EditText)view.findViewById(R.id.sum);
        mSum.setText(String.format("%.2f", 1f));

		withDraw = (Switch)view.findViewById(R.id.switch1);
		Button incButton = (Button)view.findViewById(R.id.inc);
		Button decButton = (Button)view.findViewById(R.id.dec);

		incButton.setOnClickListener(new View.OnClickListener() {
		    public void onClick(View v) {
				try {
                    float currentSum =  NumberFormat.getInstance().parse(mSum.getText().toString()).floatValue();
                    mSum.setText(String.format("%.2f", currentSum + 1f));
				} catch (ParseException e) {}
		    }
		});

		decButton.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				try {
					float currentSum = NumberFormat.getInstance().parse(mSum.getText().toString()).floatValue();
					if (currentSum > 1) {
						mSum.setText(String.format("%.2f", currentSum - 1f));
					}
				} catch (ParseException e) {
				}
			}
		});

		setHasOptionsMenu(true);
		updateBalance();
		return view;
	}

	@Override
	public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
		inflater.inflate(R.menu.balance_menu, menu);
		balanceMenu = menu;

		if(!Double.isNaN(mBalance))
			balanceMenu
				.findItem(R.id.menu_balance)
				.setTitle(getString(
						R.string.balance_value,
						getString(R.string.currency_format, mBalance)
				));
		}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		switch(item.getItemId()) {
		case R.id.menu_balance_send:
			submit();
			break;
		}
		return super.onOptionsItemSelected(item);
	}
	
	public void submit() {
		boolean validForm = false;
        NumberFormat numFormat = NumberFormat.getInstance();
        float amount = 0;

		try {
            amount = numFormat.parse(mSum.getText().toString()).floatValue();
            if (amount > 0f) {
                validForm = true;
            }
		} catch (ParseException e) {
            e.printStackTrace();
        }

		if (!validForm) {
            Toast.makeText(getActivity(), R.string.invalid_sum, Toast.LENGTH_SHORT).show();
        }
		else {
			// amount * -1 to withdraw
			if (withDraw.isChecked())
				amount *= -1;

			final ProgressDialog dialog = ProgressDialog.show(getActivity(), "",
					getString(R.string.please_wait), true);
			String url = KassenHttpUtils.getUrl(KassenConfig.KASSEN_SUBDIR_TRANSACTIONS, getActivity());

			JSONObject balanceObj = null;
			try {
				balanceObj = new JSONObject();
				balanceObj.put("amount", Float.toString(amount));
				balanceObj.put("type", 1);
			} catch (JSONException e) {
				e.printStackTrace();
			}

			JsonObjectRequest request = new JsonObjectRequest(
					Request.Method.POST,
					url,
					balanceObj,
					new Response.Listener<JSONObject>() {
						@Override
						public void onResponse(JSONObject kassenObj) {
							dialog.dismiss();
							updateBalance();
						}
					},
					new Response.ErrorListener() {
						@Override
						public void onErrorResponse(VolleyError volleyError) {
							dialog.dismiss();
							Log.e("Volley", "Error: " + volleyError.toString());
							Toast.makeText(getActivity(), volleyError.toString(), Toast.LENGTH_LONG).show();
						}
					}
			) {
				@Override
				public Map<String, String> getHeaders() throws AuthFailureError {
					return KassenHttpUtils
							.getAuthHeader(getActivity());
				}
			};

			dialog.show();
			KassenHttpUtils.getInstance(getActivity()).addToRequestQueue(request);
		}
	}

	private void updateBalance() {
		getActivity().invalidateOptionsMenu();
		String url = KassenHttpUtils.getUrl(KassenConfig.KASSEN_SUBDIR_BALANCE, getActivity());
		JsonObjectRequest request = new JsonObjectRequest(
				Request.Method.GET,
				url,
				null,
				new Response.Listener<JSONObject>() {
					@Override
					public void onResponse(JSONObject result) {
						try {
							mBalance = result.getDouble("balance");
							final Activity tmpActivity = getActivity();
							if (tmpActivity != null && !tmpActivity.isFinishing())
								getActivity().invalidateOptionsMenu();
						} catch (JSONException e) {
							e.printStackTrace();
						} catch(IllegalStateException e) {
							e.printStackTrace();
						}
					}
				},
				new Response.ErrorListener() {
					@Override
					public void onErrorResponse(VolleyError volleyError) {
						Log.e("Volley", "Error: " + volleyError.toString());
					}
				}
		) {
			@Override
			public Map<String, String> getHeaders() throws AuthFailureError {
				return KassenHttpUtils
						.getAuthHeader(getActivity());
			}
		};

		KassenHttpUtils.getInstance(getActivity()).addToRequestQueue(request);
	}
}
