package de.k4ever.k4android.database;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Map;

import com.android.volley.AuthFailureError;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonArrayRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import android.content.ContentValues;
import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;
import de.k4ever.k4android.database.KassenSQLiteHelper.History;
import de.k4ever.k4android.database.KassenSQLiteHelper.Products;
import de.k4ever.k4android.database.KassenSQLiteHelper.Transactions;
import de.k4ever.k4android.database.KassenSQLiteHelper.VirtualTransactions;
import de.k4ever.k4android.database.KassenUpdateDatasets.RequestType;
import de.k4ever.k4android.utils.KassenConfig;
import de.k4ever.k4android.utils.KassenHttpUtils;

public class KassenUpdateDatasets extends AsyncTask<RequestType, Void, Void> {
    private WeakReference<Context> mContext;
    public static enum RequestType {
        PRODUCTS, TRANSACTIONS, HISTORY, VIRTUALS
    };

    public KassenUpdateDatasets(Context context) {
        mContext = new WeakReference<Context>(context);
    }

    @Override
    protected Void doInBackground(RequestType... params) {
        String url;
        JsonArrayRequest request = null;
        final Context ctx = mContext.get();
        final DateFormat inputFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);

        if(ctx == null)
            return null;

        switch(params[0]) {
            case PRODUCTS:
                url = KassenHttpUtils.getUrl(KassenConfig.KASSEN_SUBDIR_BUYABLE, ctx);
                request = new JsonArrayRequest(url, new Response.Listener<JSONArray>() {
                    @Override
                    public void onResponse(JSONArray jsonArray) {
                        try {
                            ctx.getContentResolver().delete(KassenContentProvider.CONTENT_PRODUCTS, null, null);
                            ContentValues values = new ContentValues(10);
                            for (int i = 0; i < jsonArray.length(); i++) {
                                final JSONObject item = jsonArray.getJSONObject(i);
                                values.clear();
                                values.put(Products.COLUMN_ID, item.getInt("id"));
                                values.put(Products.COLUMN_IMAGE, item.getString(Products.COLUMN_IMAGE));
                                values.put(Products.COLUMN_NAME, item.getString(Products.COLUMN_NAME));
                                values.put(Products.COLUMN_DESCRIPTION, item.getString(Products.COLUMN_DESCRIPTION));
                                values.put(Products.COLUMN_PRICE, item.getDouble(Products.COLUMN_PRICE));
                                values.put(Products.COLUMN_DEPOSIT, item.getDouble(Products.COLUMN_DEPOSIT));
                                ctx.getContentResolver().insert(KassenContentProvider.CONTENT_PRODUCTS, values);
                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                }, new Response.ErrorListener() {
                    @Override
                    public void onErrorResponse(VolleyError volleyError) {
                        Log.e("k4android", "volley: " + volleyError.toString());
                    }
                }){
                    @Override
                    public Map<String, String> getHeaders() throws AuthFailureError {
                        return KassenHttpUtils.getAuthHeader(ctx.getApplicationContext());
                    }
                };

                break;
            case VIRTUALS:
                url = KassenHttpUtils.getUrl(KassenConfig.KASSEN_SUBDIR_VIRTUAL, ctx);
                request = new JsonArrayRequest(url, new Response.Listener<JSONArray>() {
                    @Override
                    public void onResponse(JSONArray jsonArray) {
                        try {
                            ctx.getContentResolver().delete(KassenContentProvider.CONTENT_VIRTUALS, null, null);
                            ContentValues values = new ContentValues(10);
                            for(int i = 0; i < jsonArray.length(); i++) {
                                final JSONObject item = jsonArray.getJSONObject(i);
                                values.clear();
                                values.put(VirtualTransactions.COLUMN_ID, item.getInt("id"));
                                values.put(VirtualTransactions.COLUMN_DATETIME, inputFormat.parse(item.getString("dateTime")).getTime());
                                values.put(VirtualTransactions.COLUMN_AMOUNT, item.getDouble("amount"));
                                values.put(VirtualTransactions.COLUMN_USER, item.getJSONObject("user").getString("username"));
                                values.put(VirtualTransactions.COLUMN_RECIPIENT, item.getJSONObject("recipient").getString("username"));
                                values.put(VirtualTransactions.COLUMN_COMMENT, item.getString("comment"));
                                ctx.getContentResolver().insert(KassenContentProvider.CONTENT_VIRTUALS, values);
                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                        } catch (ParseException e) {
                            e.printStackTrace();
                        }
                    }
                }, new Response.ErrorListener() {
                    @Override
                    public void onErrorResponse(VolleyError volleyError) {
                        Log.e("k4android", "volley: " + volleyError.toString());
                    }
                }){
                    @Override
                    public Map<String, String> getHeaders() throws AuthFailureError {
                        return KassenHttpUtils.getAuthHeader(ctx.getApplicationContext());
                    }
                };
                break;
            case TRANSACTIONS:
                url = KassenHttpUtils.getUrl(KassenConfig.KASSEN_SUBDIR_TRANSACTIONS, ctx);
                request = new JsonArrayRequest(url, new Response.Listener<JSONArray>() {
                    @Override
                    public void onResponse(JSONArray jsonArray) {
                        try {
                            ContentValues values = new ContentValues(10);
                            ctx.getContentResolver().delete(KassenContentProvider.CONTENT_TRANSACTIONS, null, null);
                            for(int i = 0; i < jsonArray.length(); i++) {
                                final JSONObject item = jsonArray.getJSONObject(i);
                                values.clear();
                                values.put(Transactions.COLUMN_AMOUNT, item.getDouble("amount"));
                                values.put(Transactions.COLUMN_TYPE, item.getJSONObject("transactionType").getString("name"));
                                values.put(Transactions.COLUMN_CHECKED, item.getBoolean("checked") ? 1 : 0);
                                values.put(Transactions.COLUMN_DATETIME, inputFormat.parse(item.getString("dateTime")).getTime());
                                ctx.getContentResolver().insert(KassenContentProvider.CONTENT_TRANSACTIONS, values);
                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                        } catch (ParseException e) {
                            e.printStackTrace();
                        }
                    }
                }, new Response.ErrorListener() {
                    @Override
                    public void onErrorResponse(VolleyError volleyError) {
                        Log.e("k4android", "volley: " + volleyError.toString());
                    }
                }){
                    @Override
                    public Map<String, String> getHeaders() throws AuthFailureError {
                        return KassenHttpUtils.getAuthHeader(ctx.getApplicationContext());
                    }
                };

                break;
            case HISTORY:
                url = KassenHttpUtils.getUrl(KassenConfig.KASSEN_SUBDIR_HISTORY, ctx);
                request = new JsonArrayRequest(url, new Response.Listener<JSONArray>() {
                    @Override
                    public void onResponse(JSONArray jsonArray) {
                        ContentValues values = new ContentValues(10);
                        ctx.getContentResolver().delete(KassenContentProvider.CONTENT_HISTORY, null, null);
                        try {
                            for (int i = 0; i < jsonArray.length(); i++) {
                                final JSONObject item = jsonArray.getJSONObject(i);
                                values.clear();
                                values.put(History.COLUMN_ID, item.getInt("id"));
                                values.put(History.COLUMN_PRICE, item.getDouble("price"));
                                values.put(History.COLUMN_DATETIME, inputFormat.parse(item.getString("dateTime")).getTime());

                                String itemsString = "";
                                final JSONArray purchases = item.getJSONArray("purchase_set");
                                for (int j = 0; j < purchases.length(); j++) {
                                    itemsString += purchases.getJSONObject(j).getJSONObject("buyable").getInt("id");
                                    if (j < purchases.length() - 1) {
                                        itemsString = itemsString + ",";
                                    }
                                }

                                values.put(History.COLUMN_ITEMS, itemsString);
                                ctx.getContentResolver().insert(KassenContentProvider.CONTENT_HISTORY, values);
                            }
                        } catch (ParseException e) {
                            e.printStackTrace();
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                }, new Response.ErrorListener() {
                    @Override
                    public void onErrorResponse(VolleyError volleyError) {
                        Log.e("k4android", "volley: " + volleyError.toString());
                    }
                }){
                    @Override
                    public Map<String, String> getHeaders() throws AuthFailureError {
                        return KassenHttpUtils.getAuthHeader(ctx.getApplicationContext());
                    }
                };
                break;
        }

        if(request != null)
            KassenHttpUtils.getInstance(mContext.get()).addToRequestQueue(request);

        return null;
    }
}
