/*
 * Copyright (C) 2011 Andrew Karpow <andy@mail.tu-berlin.de>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.k4ever.k4android.database;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

public class KassenSQLiteHelper extends SQLiteOpenHelper {
	private static final int DATABASE_VERSION = 3;
	private static final String DATABASE_NAME = "k4android";

	public static final class Products {
		public static final String TABLE_NAME = "kprodukte";
		public static final String COLUMN_ID = "_id";
		public static final String COLUMN_NAME = "name";
		public static final String COLUMN_IMAGE = "image";
		public static final String COLUMN_PRICE = "price";
		public static final String COLUMN_DEPOSIT = "deposit";
		public static final String COLUMN_DESCRIPTION = "description";
		public static final String COLUMN_FAVORITE = "favorite";
		public static final String TABLE_CREATE =
				"CREATE TABLE " + TABLE_NAME + " (" +
						COLUMN_ID + " INTEGER PRIMARY KEY, " +
						COLUMN_NAME + " TEXT, " +
						COLUMN_IMAGE + " TEXT, " +
						COLUMN_PRICE + " REAL, " +
						COLUMN_DEPOSIT + " REAL, " +
						COLUMN_FAVORITE + " INTEGER DEFAULT 0, " +
						COLUMN_DESCRIPTION + " TEXT);";
		public static final String[] COLUMNS_ALL = {
			COLUMN_ID, COLUMN_NAME, COLUMN_IMAGE, COLUMN_PRICE,
			COLUMN_DEPOSIT, COLUMN_DESCRIPTION, COLUMN_FAVORITE
		};
	}

	public static final class VirtualTransactions {
		public static final String TABLE_NAME = "kvirtuals";
		public static final String COLUMN_ID = "_id";
		public static final String COLUMN_USER = "user";
		public static final String COLUMN_RECIPIENT = "recipient";
		public static final String COLUMN_AMOUNT = "amount";
		public static final String COLUMN_DATETIME = "dateTime";
		public static final String COLUMN_COMMENT = "comment";
		public static final String TABLE_CREATE =
				"CREATE TABLE " + TABLE_NAME + " (" +
						COLUMN_ID + " INTEGER PRIMARY KEY, " +
						COLUMN_USER + " TEXT, " +
						COLUMN_RECIPIENT + " TEXT, " +
						COLUMN_AMOUNT + " REAL, " +
						COLUMN_DATETIME + " INTEGER, " +
						COLUMN_COMMENT + " TEXT);";
		public static final String[] COLUMNS_ALL = {
			COLUMN_ID, COLUMN_USER, COLUMN_RECIPIENT, COLUMN_AMOUNT,
			COLUMN_DATETIME, COLUMN_COMMENT
		};
	}

	public static final class Transactions {
		public static final String TABLE_NAME = "ktransactions";
		public static final String COLUMN_ID = "_id";
		public static final String COLUMN_AMOUNT = "amount";
		public static final String COLUMN_TYPE = "name";
		public static final String COLUMN_CHECKED = "checked";
		public static final String COLUMN_DATETIME = "dateTime";
		public static final String TABLE_CREATE =
				"CREATE TABLE " + TABLE_NAME + " (" +
						COLUMN_ID + " INTEGER PRIMARY KEY, " +
						COLUMN_AMOUNT + " REAL, " +
						COLUMN_TYPE + " TEXT, " +
						COLUMN_CHECKED + " INTEGER, " +
						COLUMN_DATETIME + " INTEGER);";
		public static final String[] COLUMNS_ALL = {
			COLUMN_ID, COLUMN_AMOUNT, COLUMN_TYPE, 
			COLUMN_CHECKED, COLUMN_DATETIME
		};
	}

	public static final class History {
		public static final String TABLE_NAME = "khistory";
		public static final String COLUMN_ID = "_id";
		public static final String COLUMN_PRICE = "price";
		public static final String COLUMN_DATETIME = "datetime";
		public static final String COLUMN_ITEMS = "items";
		public static final String TABLE_CREATE =
				"CREATE TABLE " + TABLE_NAME + " (" +
						COLUMN_ID + " INTEGER PRIMARY KEY, " +
						COLUMN_PRICE + " REAL, " +
						COLUMN_DATETIME + " INTEGER, " +
						COLUMN_ITEMS + " TEXT);";
		public static final String[] COLUMNS_ALL = {
			COLUMN_ID, COLUMN_PRICE, COLUMN_DATETIME, COLUMN_ITEMS
		};
	}

	public KassenSQLiteHelper(Context ctx) {
		super(ctx, DATABASE_NAME, null, DATABASE_VERSION);
	}

	@Override
	public void onCreate(SQLiteDatabase db) {
		db.execSQL(Products.TABLE_CREATE);
		db.execSQL(Transactions.TABLE_CREATE);
		db.execSQL(History.TABLE_CREATE);
		db.execSQL(VirtualTransactions.TABLE_CREATE);
	}

	@Override
	public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
		if(oldVersion == 1 && newVersion == 2) {
			db.execSQL(Transactions.TABLE_CREATE);
			db.execSQL(History.TABLE_CREATE);
		}

		if(oldVersion == 2 && newVersion == 3) {
			db.execSQL("DROP TABLE \""+Transactions.TABLE_NAME+"\";");
			db.execSQL(Transactions.TABLE_CREATE);
			db.execSQL(VirtualTransactions.TABLE_CREATE);
		}

	}
}
