/*
 * Copyright (C) 2011 Andrew Karpow <andy@mail.tu-berlin.de>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.k4ever.k4android.utils;

import android.content.Context;
import android.database.Cursor;
import android.graphics.Color;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CursorAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.android.volley.toolbox.ImageLoader;
import com.android.volley.toolbox.NetworkImageView;
import de.k4ever.k4android.R;
import de.k4ever.k4android.database.KassenSQLiteHelper.Products;

public class KassenListeAdapter extends CursorAdapter  {
	private LayoutInflater mInflater;
	ImageLoader mImageLoader;


	public KassenListeAdapter(Context context, Cursor c, int flags) {
		super(context, c, flags);
		mInflater = LayoutInflater.from(context);
		mImageLoader = KassenHttpUtils.getInstance(context).getImageLoader();
	}

	@Override
	public void bindView(View view, Context context, Cursor cursor) {
		NetworkImageView networkImageView = (NetworkImageView) view.findViewById(R.id.networkImageView);
		TextView produtTitleView = (TextView) view.findViewById(R.id.producttitle);
		TextView priceView = (TextView) view.findViewById(R.id.price);
		//TextView depositView = (TextView) view.findViewById(R.id.deposit);

		final int id = cursor.getInt(cursor.getColumnIndex(Products.COLUMN_ID));
		final String img = cursor.getString(cursor.getColumnIndex(Products.COLUMN_IMAGE));
		final String name = cursor.getString(cursor.getColumnIndex(Products.COLUMN_NAME));
		final Double price = cursor.getDouble(cursor.getColumnIndex(Products.COLUMN_PRICE));
		final int favorite = cursor.getInt(cursor.getColumnIndex(Products.COLUMN_FAVORITE));

		if(networkImageView != null) {
			networkImageView.setImageUrl(
					KassenHttpUtils.getMediaURL(context) + img,
					mImageLoader);
			produtTitleView.setText(name);
			if(favorite > 0)
				produtTitleView.setTextColor(Color.rgb(0, 100, 0));
			else
				produtTitleView.setTextColor(Color.BLACK);
			
			priceView.setText(String.format("EUR %.2f", price));
			/*depositView.setText(
					deposit == 0.0 ? "" : 
						String.format(context.getString(R.string.deposit_format), deposit));*/
		}
	}

	@Override
	public View newView(Context context, Cursor cursor, ViewGroup parent) {
		final View view = mInflater.inflate(R.layout.listitem_products, parent, false);
		return view;
	}
}
