package de.k4ever.k4android.fragments;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

import android.database.Cursor;
import android.graphics.Color;
import android.os.Bundle;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.CursorLoader;
import android.support.v4.content.Loader;
import android.support.v4.widget.SimpleCursorAdapter;
import android.support.v4.widget.SimpleCursorAdapter.ViewBinder;
import android.support.v4.widget.SwipeRefreshLayout;
import android.view.View;
import android.widget.CheckBox;
import android.widget.TextView;
import de.k4ever.k4android.R;
import de.k4ever.k4android.database.KassenContentProvider;
import de.k4ever.k4android.database.KassenSQLiteHelper.Transactions;
import de.k4ever.k4android.database.KassenUpdateDatasets;

public class TransactionsListFragment extends SwipeRefreshListFragment
implements LoaderManager.LoaderCallbacks<Cursor> {
	private SimpleCursorAdapter mAdapter;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
	}

	@Override public void onActivityCreated(Bundle savedInstanceState) {
		super.onActivityCreated(savedInstanceState);
		setEmptyText(getString(R.string.please_update));

		mAdapter = new SimpleCursorAdapter(getActivity(),
				R.layout.listitem_transactions, null,
				new String[] { 
			Transactions.COLUMN_AMOUNT, 
			Transactions.COLUMN_CHECKED,
			Transactions.COLUMN_DATETIME,
			Transactions.COLUMN_TYPE
		}, new int[] {
			R.id.amount,
			R.id.checked,
			R.id.datetime,
			R.id.type
		}, 0);
		mAdapter.setViewBinder(new ViewBinder() {
			@Override
			public boolean setViewValue(View view, Cursor cursor, int columnIndex) {
				switch(view.getId()) {
				case R.id.datetime:
					final long datetime = cursor.getLong(columnIndex);
					final String date = DateFormat.
							getDateTimeInstance(DateFormat.SHORT, DateFormat.SHORT, Locale.GERMANY).
							format(new Date(datetime));
					((TextView)view).setText(date);
					return true;
				case R.id.amount:
					final double amount = cursor.getDouble(columnIndex);
					((TextView)view).setText(String.format(getString(R.string.currency_format), amount));
					if(amount > 0)
						((TextView)view).setTextColor(Color.rgb(0, 128, 0));
					else
						((TextView)view).setTextColor(Color.RED);

					return true;
				case R.id.checked:
					final boolean checked = cursor.getInt(columnIndex) == 1;
					((CheckBox)view).setChecked(checked);
					return true;
				default:
					return false;
				}
			}
		});

		setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener() {
			@Override
			public void onRefresh() {
				if (!isRefreshing()) {
					setRefreshing(true);
				}
				new KassenUpdateDatasets(getActivity()) {
					@Override
					protected void onPostExecute(Void result) {
						super.onPostExecute(result);

						setRefreshing(false);
					}
				}.execute(KassenUpdateDatasets.RequestType.TRANSACTIONS);
			}
		});

		setListAdapter(mAdapter);
		setListShown(false);
		getLoaderManager().initLoader(0, null, this);
	}

	@Override
	public Loader<Cursor> onCreateLoader(int id, Bundle args) {
		return new CursorLoader(getActivity(), 
				KassenContentProvider.CONTENT_TRANSACTIONS, 
				null, null, null, 
				Transactions.COLUMN_DATETIME + " DESC");
	}

	@Override
	public void onLoadFinished(Loader<Cursor> loader, Cursor data) {
		mAdapter.swapCursor(data);

		if (isResumed()) {
			setListShown(true);
		} else {
			setListShownNoAnimation(true);
		}
	}

	@Override
	public void onLoaderReset(Loader<Cursor> arg0) {
		mAdapter.swapCursor(null);
	}
}
