package de.k4ever.k4android.fragments;

import android.app.ProgressDialog;
import android.content.DialogInterface;
import android.content.SharedPreferences.Editor;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentTransaction;
import android.util.Log;
import android.util.Patterns;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.TextView.OnEditorActionListener;
import android.widget.Toast;
import com.android.volley.AuthFailureError;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import de.k4ever.k4android.R;
import de.k4ever.k4android.utils.KassenConfig;
import de.k4ever.k4android.utils.KassenHttpUtils;
import de.k4ever.k4android.utils.KassenUtils;
import org.json.JSONObject;

import java.util.Map;

public class LoginFragment extends DialogFragment implements OnEditorActionListener {
	private EditText mServerURL, mPassword, mUsername;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setStyle(STYLE_NORMAL, android.R.style.Theme_Holo_Dialog);
	}

	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container,
							 Bundle savedInstanceState) {
		View v = inflater.inflate(R.layout.layout_login, container, false);

		mUsername = (EditText) v.findViewById(R.id.username);
		mUsername.setText(PreferenceManager.getDefaultSharedPreferences(
				getActivity()).getString("pref_username", ""));
		mServerURL = (EditText) v.findViewById(R.id.apiurl);
		mServerURL.setText(PreferenceManager.getDefaultSharedPreferences(
				getActivity()).getString("pref_url", ""));
		mPassword = (EditText) v.findViewById(R.id.password);
		mPassword.setOnEditorActionListener(this);
		mPassword.setText(PreferenceManager.getDefaultSharedPreferences(
				getActivity()).getString("pref_password", ""));

		// Watch for button clicks
		Button button = (Button)v.findViewById(R.id.login);
		button.setOnClickListener(new OnClickListener() {
			public void onClick(View v) {
				login();
			}
		});
		getDialog().setTitle(getString(R.string.please_supply_credentials));

		return v;
	}

	@Override
	public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
		if (EditorInfo.IME_ACTION_DONE == actionId) {
			login();
			return true;
		}
		return false;
	}

	@Override
	public void onCancel (DialogInterface dialog) {
		getActivity().finish();
	}

	private void login() {
		if (mServerURL.getText().toString().length() == 0 ) {
			mServerURL.setError(getText(R.string.error_no_input));
			mServerURL.requestFocus();
			return;
		}

		if (!Patterns.WEB_URL.matcher(mServerURL.getText()).matches()) {
			mServerURL.setError(getText(R.string.error_no_weburl));
			mServerURL.requestFocus();
			return;
		}

		if (mUsername.getText().toString().length() == 0 ) {
			mUsername.setError(getText(R.string.error_no_input));
			mUsername.requestFocus();
			return;
		}

		if (mPassword.getText().toString().length() == 0 ) {
			mPassword.setError(getText(R.string.error_no_input));
			mPassword.requestFocus();
			return;
		}

		// make sure URL has protocol ends with slash
		String k4everUrl = mServerURL.getText().toString();
		if (!k4everUrl.endsWith("/"))
			k4everUrl += "/";
		if (!k4everUrl.startsWith("http"))
			k4everUrl = "http://" + k4everUrl;

		final Editor prefs = PreferenceManager.getDefaultSharedPreferences(getActivity()).edit();
		prefs.putString("pref_url", k4everUrl);
		prefs.putString("pref_username", mUsername.getText().toString());
		prefs.putString("pref_password", mPassword.getText().toString());
		prefs.putBoolean("pref_sortorder", true);
		prefs.apply();

		KassenHttpUtils.destroyInstance();
		String url = KassenHttpUtils.getUrl(KassenConfig.KASSEN_SUBDIR_BALANCE, getActivity());

		final ProgressDialog dialog = ProgressDialog.show(getActivity(), "",
				getString(R.string.please_wait), true);
		JsonObjectRequest request = new JsonObjectRequest(
				Request.Method.GET,
				url,
				null,
				new Response.Listener<JSONObject>() {
					@Override
					public void onResponse(JSONObject result) {
						dialog.dismiss();

						if(!KassenUtils.parseMoney(result, getActivity())) {
							Toast.makeText(getActivity(), R.string.error_wrongpw, Toast.LENGTH_LONG).show();
						} else {
							prefs.putBoolean("pref_loginsuccess", true);
							prefs.apply();
							SyncFragment fragment = new SyncFragment();
							FragmentTransaction transaction = getFragmentManager().beginTransaction();
							transaction.add(fragment, "sync");
							transaction.addToBackStack(null);
							transaction.commit();
						}
					}
				},
				new Response.ErrorListener() {
					@Override
					public void onErrorResponse(VolleyError volleyError) {
						dialog.dismiss();
						Log.e("Volley", "Error: " + volleyError.toString());

						Toast.makeText(getActivity(), R.string.error_wrongpw, Toast.LENGTH_LONG).show();
					}
				}
		) {
			@Override
			public Map<String, String> getHeaders() throws AuthFailureError {
				return KassenHttpUtils.getAuthHeader(getActivity());
			}
		};

		KassenHttpUtils.getInstance(getActivity()).addToRequestQueue(request);
	}
}
