package de.freewarepoint.whohasmystuff;

import android.app.DatePickerDialog;
import android.app.Dialog;
import android.app.DialogFragment;
import android.os.Bundle;
import android.widget.DatePicker;

public class DatePickerFragment extends DialogFragment implements DatePickerDialog.OnDateSetListener {

    private int year;
    private int month;
    private int day;

    @Override
    public void setArguments(Bundle args) {
        super.setArguments(args);
        year = args.getInt("year");
        month = args.getInt("month");
        day = args.getInt("day");
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        return new DatePickerDialog(getActivity(), this, year, month, day);
    }

    public void onDateSet(DatePicker view, int year, int month, int day) {
        if (getTag().equals("fragment_pick_date")) {
            ((AddObject)getActivity()).updateDate(year, month, day);
        }
        else if (getTag().equals("fragment_pick_return_date")) {
            ((AddObject)getActivity()).updateReturnDate(year, month, day);
        }
    }

}

