package de.determapp.android.ui.receive

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.Fragment
import androidx.lifecycle.Observer
import androidx.recyclerview.widget.LinearLayoutManager
import de.determapp.android.R
import de.determapp.android.service.DownloadLocalNetworkPackageService
import de.determapp.android.service.DownloadLocalNetworkPackageServiceRequest
import kotlinx.android.synthetic.main.fragment_receive_content.*

class ReceiveContentFragment : Fragment(), Handlers {
    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        return inflater.inflate(R.layout.fragment_receive_content, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        val adapter = ReceiveContentAdapter()

        recycler.layoutManager = LinearLayoutManager(context)
        recycler.adapter = adapter

        ReceiveContentList.with(context!!).observe(this, Observer {
            if (it != null) {
                adapter.data = it
            } else {
                adapter.data = emptyList()
            }
        })

        adapter.handlers = this
    }

    override fun onUpdateOrDownloadRequested(item: ContentItem) {
        DownloadLocalNetworkPackageService.start(context!!, DownloadLocalNetworkPackageServiceRequest(
                baseUrl = item.baseUrl,
                projectId = item.projectId,
                title = item.title,
                expectedHash = item.hash
        ))
    }
}
