import React from 'react';
import PropTypes from 'prop-types';
import Svg, { Path } from 'react-native-svg';

const Constituency = props => (
  <Svg width="1em" height="1em" viewBox="0 0 251 157" {...props}>
    <Path
      d="M197 10l-1-.5 1-.5v1zm53 40.702l-1.054 2.085-2.458.695-.351 1.39-1.405-.347-2.458 2.432-3.512.348-2.81-1.39L232.44 58l-2.107-1.043-.351-1.737-.703-.695-.35.347-2.108-3.822-6.673-4.17-1.054.347-1.053-.695h-1.756l-1.405-2.085-3.863-1.043-5.268 2.433-2.107-.695-1.756.695-3.161-1.043-1.756.695 2.107 2.78v6.603l-1.053 1.39-2.108 1.043 1.405 1.043-1.053 1.737v2.085l-4.566 4.17v1.043l-1.054 1.043-.35 2.78-5.62 2.085-.702-.695-1.756.347-.703 2.085-1.405 1.738v4.17l-1.404.348-2.108-.695-2.81 1.39v1.042l-6.672 1.738-.351 2.085-1.405.347-.351 2.086-.703.347-1.404-1.042-.703 1.042-.702-.347-1.054.695-.35-2.78.701-.348-1.404-.348.35-.347-2.106-2.78-3.512 2.432-1.405 3.128-1.405 1.043v1.042l1.756.695v1.043l-2.107 2.085.702.347-1.404 3.823-1.405.695-2.107-1.042-1.054 1.39-.702-1.39-2.81 1.737v1.738l3.512 2.432-.351.348-3.161.347-2.107-2.432-.351 1.042-.703-.695-1.405.348-1.053 1.39-6.322-2.085-2.458.695V107l-1.054 2.085-1.405.348-1.404-.348.35-2.085-1.404-1.39v-2.433l-3.16-.695 1.404 2.433-2.107 1.042-.351 1.738-1.054 1.043-3.16.695-3.513-.695-.351 3.475-.702 1.042-1.054.348v1.39h-1.405l-1.053.695-.703 1.39-4.917 1.043-3.16 2.432-2.81 4.17-3.16 1.043-.352-.348 1.405-1.737-.702-1.738.35-2.78h-.702l-.35-1.042-4.566-4.518-.352-1.043h1.756l-1.053-1.39-.703-2.78-1.756 1.738-3.863.695.351 1.737-.702 2.085h-.702l-2.459-3.475-.702.348v-.695l-2.107.695v-.695h-1.405l.702 1.737-.702 3.475 1.756 2.433h.702l-1.053 3.823 1.053 1.39-.351.695 2.107 1.737-.702 1.043-2.81-.347-3.16-4.17v-7.299l-2.459-.347-2.107-2.433h-4.215l-2.107 1.043-.351 2.432.702 1.043 1.054-.348.351 4.518-1.053.348-.703-.695-2.458-.348-4.215 1.043-2.458 1.39-1.054 3.127-1.404.348-1.756 1.738-1.756.347-1.756-1.042-5.268 2.432.702 2.433 2.107 1.042 1.756 2.433 1.405 3.128v1.39l2.458 2.78-.35 2.78.702 1.043h1.756l2.458-3.476 2.81-1.39-1.054-.695v-.695h2.107l-.351 2.085-1.756 1.738.351.347 1.756-1.737-.351 1.39.702-.348.352.695-1.756 6.95-1.756.348L44.9 156l-5.62-3.128-5.267-1.737v-.695l-2.107-.348-.703-1.737-1.405-.695-1.053.347-.703 1.738-3.863-1.738-.702.695-1.756-1.042-.351 2.085h-1.405l.35-3.475.703-1.39 1.054 1.39.351-.348-1.405-1.39-3.512-.695-3.16.695.35-.695h-1.053l-1.756-2.78-2.458-1.39-.703-1.39-3.16.695-1.405-1.738-1.405-3.475L1 132.02l.351-1.042h4.215l2.107-3.128-.351-1.042-3.512-1.043-.352-1.738 1.054-2.432 2.458-2.085 1.405-3.823 2.107-.348 1.405 1.738 4.215-3.475 4.565.695-.702-1.39 3.512-2.78v-.695l-2.107-2.78-.352-3.823-1.053-3.128.35-5.213 3.513-3.822-1.054-2.085-2.81-.695-2.106-2.086-4.917-10.078-3.161-4.17 1.756-1.737 2.107.695 1.756-.348 2.81-3.823.35-3.822-1.755-2.085-1.405-3.476 1.054-.347 1.053 1.042 1.054 2.433 2.81-1.042 2.458.347.702-.695h1.054l1.054-1.738 1.404-.695-.35-1.39 2.106-.347.703-2.085 2.81.695 1.755-3.475-1.405-2.086.352-2.432.702.347 2.81-1.737 1.053-1.738 3.863-2.085 1.405-4.17.703-.348 2.81-.347 4.565 2.085 3.16.695 1.054-.348-.351-.695 2.81 1.043 1.756-1.738L60 38.54h.703l.702 1.39 1.054-.695v1.738h2.107l.351.695.351-2.085 1.756-.348 1.054-2.433.702.348-.35-1.39 1.053-.348 1.756 1.738 3.512.347 1.053-.347-.35-.695 2.458-.695 1.756.695v-.695h1.053l3.512 2.085.351 1.043.703-1.39 1.756.694 1.405-.695v1.738l3.512-.347 2.458 1.042 2.81-1.39 1.404-3.128-3.16-2.432 1.755-.348 5.62 2.433 6.672.695 2.459-.348.702-1.042.703.695.702-1.39 1.405-.695 1.053 1.042h1.405v-3.127l1.756 3.127 2.459 2.085 2.458.348 1.054.695.702-1.738 6.322-3.127 3.16 1.042v2.085l1.405-.347 2.459-3.475.702-4.518h.702l.352-1.738 4.214.695 1.405-3.127 1.756.347-.351 2.78 3.16.695.703.695v.695l-1.054.348v1.043l4.917 1.737 2.107-2.085 2.107-1.043 1.054 1.043-1.405 1.39 3.16-.695 1.757.695.702 2.085h2.459v-.695l.35 1.043 1.757-.695 1.756 2.432-.351.695 4.565.695.351-1.042 1.405 1.39 2.459-.695-7.376-4.17 2.459-2.433-.351-1.043 1.756-.695v-1.042l1.404-1.738 2.108-.695v1.39l1.053-.695-.702-3.475.351-1.39 1.054.348-.352-2.433h.703l1.053 1.042.352-.695-.703-1.042.703-1.738-1.756-1.39-.703-1.737 1.756 1.39L187.487 9l-.352 1.39 1.054-.695-1.054 1.043 1.405 1.737v1.043l.703.695h2.81l.35 2.085.703-.695.702.695 1.405-.695 1.756-2.78-1.756 3.822.702.695-1.053-.347-.703.695h1.756l1.756 2.085h1.756l-1.053 2.085h1.756l1.756 1.043 1.053-.348.703 1.043-1.054.695.351.695 2.81.695-1.405 2.085v1.738l.703.347-.703 1.043h1.756l.703-2.433.702 1.043h-.702l.35 1.39 1.406.347h.702l.351-1.39 3.512.695-1.053-.347 1.053-1.39-.702-.348.35-1.043-1.053-.347 1.054-.695 2.107 2.085.703-2.085v1.737l2.107.696.35-3.823-2.106.347 1.405-1.39h-2.81l1.054-.347-1.054-.695v-.695l1.756 1.042.702-.347-.35-.348h1.755l.351 1.39 1.756-1.042-.35-2.433h1.053l.35 3.823-.35-.695-2.108 1.39-.35 2.432.702-.695 1.053.348.351-1.39 1.054-.348.351-1.042 3.161-.695-1.756-1.39v-1.043l1.054.348 1.053 1.39 1.054-1.043 2.107.348 3.863-3.823.351-1.39 4.917-3.823 5.97-2.78 1.054.695-5.97 2.78-4.566 4.17.351 1.043-2.81 2.78h2.108l-.702 1.043h-1.756l-.352 1.042-1.404.348-.703-.695-3.16.695-1.757 1.042 4.215.348-2.459.347 1.756 1.043-.35.695-1.054-.695.35 1.39-.702 1.043v-1.738l-3.16 1.043-.703 1.737 1.054 1.043-1.756-.695-.351.695.702 1.042 2.107-.347 3.512 1.39-1.405.695-2.81-1.738-1.404 1.043.351.695h1.756l-1.405.695v2.432l2.81 1.39-.702.696 1.404 1.042 1.054-.695 2.458-.347-.702-1.738h1.405l1.756-1.738 1.053-3.127 1.405-1.043h2.107v1.738l1.756 1.39 2.81-1.043 4.566.695 1.053-.695 1.405.695-1.054.348-.35 1.39-2.108-.695-1.405.695 1.405 2.78.702 3.823 2.459 1.737-1.054.348 1.054.695-.703 2.433h1.054v1.39H250v1.042zM195.91 14l-.728-.364.363-.727-.727-2.182-1.818.728v-.728h.727l-.363-1.09h1.818l.727-2.91.727-.727-.363 2.91 2.182.726 1.818-.363.727-1.455v1.455l-4.727.727v2.91l-.364 1.09zm13.882-10.813l.708-.437-.354-1.75.708 1.75 1.771-1.313-1.417 2.625 4.25-.875 1.063-1.312-.354 1.313L219 5.812l-.354.875-3.542-2.625-2.125.875.354 1.313h-2.479l-1.417 1.313.355 1.312h-.709L208.73 8l-1.062 1.75-2.834 2.188-1.062 2.624L202 15v-.875l1.77-.875V11.5l6.022-5.688-1.063-2.187.708.438.355-.875z"
      stroke="#9B9B9B"
      strokeWidth={1.25}
      fillOpacity={0.9}
      strokeLinecap="round"
      strokeLinejoin="round"
      fill="#D5D5D5"
      fillRule="evenodd"
      {...props.childProps}
    />
  </Svg>
);

Constituency.propTypes = {
  childProps: PropTypes.shape(),
};

Constituency.defaultProps = {
  childProps: {},
};

export default Constituency;
