import React from 'react';
import Svg, { G, Path } from 'react-native-svg';
import PropTypes from 'prop-types';
/* SVGR has dropped some elements not supported by react-native-svg: title */

export const CduCsu = props => (
  <Svg width="1em" height={(props.width / 851) * 227} viewBox="0 0 851 227" {...props}>
    <G fill="none" fillRule="evenodd">
      <Path fill="#FFF" d="M0 .002h850.39v226.77H0z" />
      <Path
        d="M26.192 187.364l2.049-.373c1.399-.272 2.21-.916 2.21-4.264v-21.232c0-3.345-.809-3.991-2.21-4.263l-2.049-.377v-1.562c1.078.051 4.313.104 6.091.104 3.45 0 8.033 0 11.214-.054 3.45-.052 4.526-.163 5.875-.216 0 2.479.108 5.663.218 7.333H47.7l-.483-2.48c-.27-1.237-.973-2.152-2.909-2.152l-9.704-.053v13.476h7.491c1.89 0 2.156-.484 2.318-1.401l.538-2.588h1.673c-.055 1.351-.163 3.234-.163 4.958 0 1.46.108 3.881.163 5.229h-1.671l-.482-2.315c-.159-.916-.482-1.563-2.374-1.563h-7.491v9.163c0 3.348.809 4.103 2.21 4.265l3.235.374v1.563c-1.35-.055-4.904-.164-7.333-.164-2.531 0-5.177.109-6.521.164v-1.563l-.005-.009zM53.69 187.419l1.777-.271c1.237-.215 1.778-.535 1.778-4.31v-13.156c0-2.749 0-3.395-3.502-4.092v-1.296c2.803-.812 4.795-1.401 7.492-2.588v4.038c1.348-1.888 4.583-3.771 6.792-3.771.969 0 1.671.161 2.317.32l-.435 3.719c-.645-.323-1.994-.485-2.962-.485-1.889 0-4.046.7-5.716 2.051v15.26c0 3.771.593 4.149 1.775 4.31l2.48.271v1.512c-1.348-.057-4.258-.217-6.307-.217-2.104 0-4.15.16-5.499.217l.01-1.512z"
        fill="#000"
      />
      <Path
        d="M72.849 182.893c0-5.064 4.475-8.301 11.373-8.301.755 0 2.104 0 2.909.056v-3.132c0-4.148-1.831-6.356-6.034-6.356-2.481 0-4.476.535-6.146 1.453l-.27-1.562c1.292-1.505 4.42-3.069 7.386-3.069 6.09 0 9.107 3.338 9.107 8.569 0 4.203-.217 8.301-.217 13.149 0 2.645.974 3.396 4.259 3.396v1.512c-.917.592-2.531.969-4.096.969-2.479 0-3.935-1.457-3.935-3.666h-.105c-.972 1.617-3.882 3.666-7.172 3.666-4.15 0-7.059-2.748-7.059-6.684zm14.067 1.183c0-1.94.107-5.979.164-7.113-.594-.054-1.512-.054-2.104-.054-5.554 0-8.033 1.99-8.033 5.282 0 2.642 1.779 4.255 4.422 4.255 2.477.001 4.474-1.13 5.551-2.37zM98.566 187.419l1.774-.271c1.24-.156 1.78-.535 1.78-4.31v-23.773c0-2.75 0-3.396-3.505-4.1v-1.289c2.801-.812 4.796-1.564 7.495-2.912v32.075c0 3.771.588 4.149 1.774 4.311l1.778.271v1.512c-1.349-.056-3.555-.165-5.604-.165-2.104 0-4.152.109-5.496.165l.004-1.514zm16.979-1.241c-2.212-2.267-4.526-5.604-8.945-11.21l6.848-7.708c.752-.812 1.021-1.515 1.021-2.048 0-.596-.379-.917-2.05-1.028v-1.562c1.352.055 3.287.105 5.282.105 1.729 0 3.396-.055 4.746-.105v1.508c-2.808.219-5.981 3.021-8.194 5.501l-3.719 4.098c3.123 3.881 7.489 9.379 9.165 10.939 1.399 1.295 2.585 2.751 4.635 2.911v1.4c-.595.325-1.67.38-2.585.38-2.269.002-4.264-1.241-6.204-3.181z"
        fill="#000"
        fillRule="nonzero"
      />
      <Path
        d="M129.642 183.216v-18.062h-3.292v-1.729c3.396-1.832 4.641-3.828 5.557-7.114h1.724v6.312h7.816v2.529h-7.816v17.143c0 3.232.97 4.584 3.611 4.584 1.508 0 3.184-.38 3.937-.65l.216 1.081c-.753 1.237-3.396 2.268-5.877 2.268-4.371-.001-5.876-1.944-5.876-6.362z"
        fill="#000"
      />
      <Path
        d="M145.068 187.419l2.476-.271c1.244-.156 1.78-.535 1.78-4.31v-13.156c0-2.749 0-3.395-3.503-4.092v-1.296c2.802-.812 4.797-1.455 7.491-2.588v21.132c0 3.771.594 4.148 1.777 4.31l1.944.271v1.511c-1.35-.054-3.725-.163-5.769-.163-2.106 0-4.857.109-6.2.163l.004-1.511zm3.017-33.801a2.871 2.871 0 0 1 2.854-2.854c1.562 0 2.859 1.295 2.859 2.854 0 1.562-1.297 2.856-2.859 2.856-1.563.003-2.854-1.293-2.854-2.856zM162.055 175.993c0-7.656 4.738-14.018 12.348-14.018 7.812 0 12.069 5.655 12.069 13.582 0 7.707-4.799 14.018-12.45 14.018-7.87.002-11.967-5.499-11.967-13.582zm19.945.106c0-7.114-2.642-11.915-7.814-11.915-4.798 0-7.601 4.425-7.601 11.323 0 7.387 2.907 11.854 7.759 11.854 5.065.003 7.656-4.418 7.656-11.262z"
        fill="#000"
        fillRule="nonzero"
      />
      <Path
        d="M192.424 187.419l1.774-.271c1.242-.215 1.781-.535 1.781-4.31v-13.156c0-2.749 0-3.395-3.504-4.092v-1.296c2.802-.812 4.799-1.401 7.487-2.588v3.771c1.779-1.669 4.855-3.502 7.711-3.502 6.364 0 8.195 3.665 8.195 9.108v11.754c0 3.771.592 4.095 1.775 4.31l1.778.271v1.512c-1.351-.056-3.557-.165-5.604-.165-2.104 0-4.149.109-5.499.165v-1.512l1.773-.271c1.243-.215 1.778-.535 1.778-4.31v-11.159c0-4.101-1.074-6.521-5.656-6.521-2.43 0-4.854 1.188-6.259 2.104v15.581c0 3.771.6 4.095 1.78 4.31l1.781.271v1.512c-1.349-.055-3.562-.164-5.604-.164-2.104 0-4.154.109-5.499.164l.012-1.516z"
        fill="#000"
      />
      <Path
        d="M235.842 187.419l2.475-.271c1.245-.156 1.783-.535 1.783-4.31v-13.156c0-2.749 0-3.395-3.506-4.092v-1.296c2.804-.812 4.8-1.455 7.489-2.588v21.132c0 3.771.597 4.148 1.78 4.31l1.944.271v1.511c-1.351-.054-3.728-.163-5.771-.163-2.105 0-4.854.109-6.198.163l.004-1.511zm3.017-33.801a2.872 2.872 0 0 1 2.854-2.854c1.564 0 2.859 1.295 2.859 2.854 0 1.562-1.295 2.856-2.859 2.856-1.563.003-2.854-1.293-2.854-2.856z"
        fill="#000"
        fillRule="nonzero"
      />
      <Path
        d="M253.693 187.419l1.772-.271c1.243-.215 1.779-.535 1.779-4.31v-13.156c0-2.749 0-3.395-3.502-4.092v-1.296c2.803-.812 4.798-1.455 7.49-2.588v3.771c1.675-1.723 4.692-3.502 7.549-3.502 3.934 0 6.092 1.505 7.114 3.986 1.995-1.996 5.5-3.986 8.354-3.986 6.363 0 7.929 3.614 7.929 9.055v11.812c0 3.771.596 4.095 1.777 4.31l1.777.271v1.512c-1.343-.056-3.558-.165-5.604-.165-2.103 0-4.15.109-5.499.165v-1.512l1.778-.271c1.239-.215 1.782-.534 1.782-4.31v-11.213c0-4.101-.812-6.471-5.396-6.471-2.422 0-5.064 1.238-6.469 2.152.27 1.135.38 2.37.38 3.72v11.812c0 3.771.593 4.095 1.774 4.31l1.78.271v1.512c-1.351-.056-3.558-.165-5.604-.165-2.102 0-4.148.109-5.499.165v-1.512l1.779-.271c1.238-.215 1.772-.534 1.772-4.31v-11.213c0-4.101-.806-6.312-5.388-6.312-2.427 0-4.693 1.028-6.094 1.943v15.581c0 3.771.595 4.095 1.78 4.31l1.777.271v1.512c-1.349-.055-3.561-.164-5.604-.164-2.105 0-4.153.109-5.497.164l.013-1.515z"
        fill="#000"
      />
      <Path
        d="M317.814 188.825c-1.938 0-3.771.053-5.657.104v-1.562l2.044-.374c1.407-.272 2.211-.917 2.211-4.265v-21.233c0-3.344-.805-3.99-2.211-4.264l-2.044-.374v-1.562c1.617.052 3.501.104 5.657.104 2.371 0 5.394-.154 8.301-.154 10.834 0 16.55 6.789 16.55 15.953 0 10.399-7.007 17.786-17.681 17.786-2.857-.003-5.067-.159-7.17-.159zm20.164-16.878c0-7.329-3.349-14.285-13.152-14.285-1.511 0-2.749.058-4.26.165v25.392c0 2.102.325 3.396 4.364 3.396 8.302-.003 13.048-5.452 13.048-14.668zM347.642 176.21c0-8.197 4.9-14.231 11.914-14.231 6.687 0 9.918 5.017 9.918 10.238 0 .701 0 1.243-.107 1.942H351.96c-.059.538-.059 1.073-.059 1.563 0 5.819 2.912 10.671 8.947 10.671 3.074 0 5.396-.646 7.114-1.513l.162 1.348c-1.025 1.679-4.417 3.348-8.3 3.348-7.926.001-12.182-5.12-12.182-13.366zM363.76 172c.917 0 1.235-.426 1.235-1.187 0-3.182-1.885-6.468-5.657-6.468-4.526 0-6.795 3.987-7.228 7.648l11.65.007z"
        fill="#000"
        fillRule="nonzero"
      />
      <Path
        d="M392.88 186.075c-1.771 1.668-4.852 3.501-7.703 3.501-6.362 0-8.194-3.666-8.194-9.11V168.66c0-2.749 0-3.396-3.504-4.098v-1.296c2.533-.428 4.8-.857 7.495-1.56v18.167c0 4.092 1.072 6.521 5.654 6.521 2.432 0 4.854-1.186 6.253-2.101v-15.639c0-2.748 0-3.396-3.503-4.097v-1.296c2.534-.428 4.8-.858 7.496-1.562v20.809c0 2.749 0 3.396 3.501 4.1v1.295c-2.428.32-5.014.917-7.494 1.669l-.001-3.497zM408.477 183.216v-18.062h-3.292v-1.729c3.396-1.832 4.64-3.828 5.558-7.114h1.722v6.312h7.816v2.529h-7.816v17.143c0 3.232.97 4.584 3.612 4.584 1.507 0 3.184-.38 3.938-.65l.216 1.081c-.754 1.237-3.396 2.268-5.877 2.268-4.37-.001-5.877-1.944-5.877-6.362zM424.442 188.334c.104-2.533 0-4.525-.164-7.062h1.997c.484 3.826 1.618 5.929 6.203 5.929 3.394 0 5.763-1.887 5.763-4.902 0-6.736-13.528-3.449-13.528-13.205 0-4.313 3.883-7.114 9.114-7.114 2.749 0 5.552.754 7.162 1.399-.104 2.312-.056 3.718.104 6.035h-1.989c-.272-3.449-1.886-5.229-5.499-5.229-3.23 0-5.332 1.408-5.332 4.152 0 6.256 13.58 3.664 13.58 13.312 0 4.312-3.939 7.927-9.323 7.927-3.342.001-5.931-.542-8.088-1.242zM447.479 176.21c0-8.032 5.868-14.231 12.938-14.231 2.854 0 5.396.646 7.161 1.29-.156 1.781-.211 4.365-.211 6.146h-2.055c-.158-3.068-1.4-5.117-5.226-5.117-4.582 0-8.406 4.205-8.406 11.371 0 6.896 3.931 10.729 9.544 10.729 2.424 0 4.637-.596 6.246-1.67l.271 1.401c-.968 1.613-3.99 3.448-7.983 3.448-7.696 0-12.279-5.18-12.279-13.367zM472.771 187.419l1.779-.271c1.229-.215 1.779-.535 1.779-4.31v-23.773c0-2.75 0-3.396-3.511-4.1v-1.289c2.805-.812 4.794-1.564 7.489-2.912v14.716c1.782-1.668 4.856-3.501 7.714-3.501 6.362 0 8.194 3.771 8.194 9.217v11.646c0 3.771.591 4.095 1.778 4.311l1.779.271v1.512c-1.35-.055-3.562-.164-5.616-.164-2.095 0-4.147.109-5.497.164v-1.512l1.779-.271c1.243-.216 1.779-.535 1.779-4.311v-11.058c0-4.091-1.073-6.626-5.655-6.626-2.425 0-4.854 1.188-6.26 2.104v15.58c0 3.771.604 4.095 1.783 4.311l1.777.271v1.512c-1.35-.056-3.562-.164-5.604-.164-2.106 0-4.149.108-5.499.164l.012-1.517z"
        fill="#000"
      />
      <Path
        d="M504.384 176.21c0-8.197 4.896-14.231 11.914-14.231 6.682 0 9.913 5.017 9.913 10.238 0 .701 0 1.243-.104 1.942h-17.413c-.052.538-.052 1.073-.052 1.563 0 5.819 2.908 10.671 8.941 10.671 3.075 0 5.396-.646 7.118-1.513l.159 1.348c-1.021 1.679-4.415 3.348-8.3 3.348-7.917.001-12.176-5.12-12.176-13.366zm16.119-4.21c.917 0 1.23-.426 1.23-1.187 0-3.182-1.885-6.468-5.657-6.468-4.525 0-6.795 3.987-7.226 7.648l11.653.007z"
        fill="#000"
        fillRule="nonzero"
      />
      <Path
        d="M531.511 187.419l1.771-.271c1.244-.215 1.78-.535 1.78-4.31v-13.156c0-2.749 0-3.395-3.499-4.092v-1.296c2.803-.812 4.795-1.401 7.489-2.588v3.771c1.778-1.669 4.849-3.502 7.713-3.502 6.361 0 8.195 3.665 8.195 9.108v11.754c0 3.771.591 4.095 1.77 4.31l1.78.271v1.512c-1.352-.056-3.55-.165-5.604-.165-2.106 0-4.15.109-5.499.165v-1.512l1.779-.271c1.241-.215 1.78-.535 1.78-4.31v-11.159c0-4.101-1.075-6.521-5.656-6.521-2.435 0-4.854 1.188-6.259 2.104v15.581c0 3.771.592 4.095 1.778 4.31l1.781.271v1.512c-1.349-.055-3.562-.164-5.611-.164-2.104 0-4.151.109-5.491.164l.003-1.516z"
        fill="#000"
      />
      <Path
        d="M580.695 188.825c-2 0-4.425.053-5.771.104v-1.562l2.045-.374c1.411-.272 2.215-.917 2.215-4.265v-21.233c0-3.344-.804-3.99-2.215-4.264l-2.045-.374v-1.562c1.351.052 3.51.052 5.656.052 3.128 0 5.666-.163 7.764-.163 6.742 0 10.305 3.02 10.305 8.196 0 3.771-3.508 6.789-6.583 7.489v.058c3.835.323 8.09 3.29 8.09 8.19 0 6.096-5.29 9.918-12.937 9.918-2.215-.001-5.018-.21-6.524-.21zm13.42-25.067c0-4.098-2.433-6.146-7.063-6.146-.646 0-2.637 0-3.721.104v12.347c1.242.104 1.945.104 3.938.104 4.415.002 6.846-3.175 6.846-6.409zm1.452 15.791c0-4.151-2.589-6.952-7.657-6.952-1.397 0-3.495.052-4.58.162v10.887c0 1.994.433 3.021 4.317 3.021 5.333 0 7.92-2.641 7.92-7.118z"
        fill="#000"
        fillRule="nonzero"
      />
      <Path
        d="M624.202 186.075c-1.771 1.668-4.847 3.501-7.7 3.501-6.359 0-8.193-3.666-8.193-9.11V168.66c0-2.749 0-3.396-3.509-4.098v-1.296c2.537-.428 4.805-.857 7.5-1.56v18.167c0 4.092 1.075 6.521 5.659 6.521 2.421 0 4.844-1.186 6.243-2.101v-15.639c0-2.748 0-3.396-3.499-4.097v-1.296c2.527-.428 4.796-.858 7.49-1.562v20.809c0 2.749 0 3.396 3.507 4.1v1.295c-2.432.32-5.014.917-7.499 1.669l.001-3.497zM637.4 187.419l1.771-.271c1.245-.215 1.778-.535 1.778-4.31v-13.156c0-2.749 0-3.395-3.496-4.092v-1.296c2.803-.812 4.791-1.401 7.486-2.588v3.771c1.779-1.669 4.85-3.502 7.712-3.502 6.364 0 8.197 3.665 8.197 9.108v11.754c0 3.771.589 4.095 1.771 4.31l1.78.271v1.512c-1.351-.056-3.55-.165-5.604-.165-2.106 0-4.148.109-5.498.165v-1.512l1.778-.271c1.241-.215 1.778-.535 1.778-4.31v-11.159c0-4.101-1.074-6.521-5.656-6.521-2.434 0-4.854 1.188-6.258 2.104v15.581c0 3.771.592 4.095 1.778 4.31l1.78.271v1.512c-1.35-.055-3.562-.164-5.614-.164-2.098 0-4.148.109-5.487.164v-1.516h.004z"
        fill="#000"
      />
      <Path
        d="M669.311 176.693c0-9.108 6.19-14.395 14.662-14.395 1.127 0 1.989.105 2.854.27v-3.504c0-2.75 0-3.396-3.507-4.1v-1.289c2.804-.812 4.805-1.564 7.489-2.912v31.48c0 2.749 0 3.396 3.508 4.098v1.291c-2.591.481-4.636.915-7.49 1.94v-2.53c-1.619 1.45-4.098 2.53-6.741 2.53-6.741.005-10.775-5.659-10.775-12.879zm17.515 8.678v-19.729c-.703-.327-2.054-.918-3.885-.918-5.386 0-9.431 3.287-9.431 10.999 0 5.438 2.806 10.777 8.194 10.777 2.1.002 3.344-.322 5.122-1.129zM699.458 176.21c0-8.197 4.896-14.231 11.913-14.231 6.68 0 9.913 5.017 9.913 10.238 0 .701 0 1.243-.104 1.942h-17.413c-.052.538-.052 1.073-.052 1.563 0 5.819 2.906 10.671 8.939 10.671 3.076 0 5.395-.646 7.122-1.513l.156 1.348c-1.021 1.679-4.414 3.348-8.301 3.348-7.915.001-12.173-5.12-12.173-13.366zm16.118-4.21c.917 0 1.231-.426 1.231-1.187 0-3.182-1.887-6.468-5.657-6.468-4.524 0-6.794 3.987-7.228 7.648l11.654.007z"
        fill="#000"
        fillRule="nonzero"
      />
      <Path
        d="M726.425 188.334c.104-2.533 0-4.525-.168-7.062h2.001c.482 3.826 1.61 5.929 6.196 5.929 3.4 0 5.771-1.887 5.771-4.902 0-6.736-13.535-3.449-13.535-13.205 0-4.313 3.886-7.114 9.109-7.114 2.75 0 5.554.754 7.174 1.399-.114 2.312-.053 3.718.104 6.035h-1.985c-.273-3.449-1.898-5.229-5.502-5.229-3.233 0-5.342 1.408-5.342 4.152 0 6.256 13.59 3.664 13.59 13.312 0 4.312-3.939 7.927-9.333 7.927-3.338.001-5.931-.542-8.08-1.242zM752.414 183.216v-18.062h-3.284v-1.729c3.395-1.832 4.638-3.828 5.55-7.114h1.729v6.312h7.818v2.529h-7.818v17.143c0 3.232.973 4.584 3.614 4.584 1.509 0 3.183-.38 3.929-.65l.226 1.081c-.76 1.237-3.399 2.268-5.877 2.268-4.38-.001-5.887-1.944-5.887-6.362z"
        fill="#000"
      />
      <Path
        d="M767.468 182.893c0-5.064 4.479-8.301 11.376-8.301.76 0 2.099 0 2.905.056v-3.132c0-4.148-1.83-6.356-6.035-6.356-2.475 0-4.478.535-6.144 1.453l-.272-1.562c1.299-1.505 4.427-3.069 7.39-3.069 6.085 0 9.106 3.338 9.106 8.569 0 4.203-.209 8.301-.209 13.149 0 2.645.969 3.396 4.259 3.396v1.512c-.917.592-2.539.969-4.102.969-2.476 0-3.938-1.457-3.938-3.666h-.106c-.968 1.617-3.877 3.666-7.163 3.666-4.148 0-7.067-2.748-7.067-6.684zm14.074 1.183c0-1.94.104-5.979.155-7.113-.59-.054-1.506-.054-2.096-.054-5.562 0-8.037 1.99-8.037 5.282 0 2.642 1.778 4.255 4.424 4.255 2.478.001 4.467-1.13 5.554-2.37zM793.088 193.401c0-3.288 3.074-5.441 5.933-6.469-1.834-.645-3.021-1.938-3.021-3.608 0-1.995 1.62-3.724 3.453-4.643-2.802-1.186-5.015-3.983-5.015-7.921 0-4.745 4.099-8.784 9.701-8.784 1.888 0 2.961.32 3.826.646h8.469v2.209h-5.173c1.396 1.35 2.423 3.502 2.423 5.767 0 5.066-4.203 8.948-9.545 8.948-.862 0-1.938-.058-2.645-.217-1.35.646-1.938 1.615-1.938 2.531 0 1.134 1.244 2.104 3.394 2.21l4.425.222c5.287.216 8.895 2.265 8.895 6.252 0 5.979-5.658 9.482-13.424 9.482-5.45.006-9.758-2.365-9.758-6.625zm19.94-1.56c0-2.912-2.907-3.937-7.923-4.152l-3.771-.162c-2.045.865-4.528 2.372-4.528 4.904 0 3.021 2.592 5.282 7.175 5.282 5.222.002 9.047-2.204 9.047-5.872zm-3.446-21.131c0-3.614-1.937-6.414-5.55-6.414-3.667 0-5.5 2.91-5.5 6.414 0 3.986 2.214 6.521 5.656 6.521 3.617-.002 5.394-3.125 5.394-6.521z"
        fill="#000"
        fillRule="nonzero"
      />
      <Path
        d="M456.696 29.206c-10.301 27.324-31.417 56.181-68.887 62.354v15.8c48.704-4.436 82.267-27.226 100.912-48.083V29.208l-32.025-.002z"
        fill="#C31923"
      />
      <Path
        d="M387.808 78.484c21.554-6.801 32.419-33.155 34.087-49.276h-34.087v49.276z"
        fill="#000"
      />
      <Path
        d="M387.808 119.868v10.211c46.092 0 86.962-3.774 100.913-7.735V94.675c-22.881 12.737-66.492 23.706-100.913 25.193z"
        fill="#E6C823"
      />
      <Path
        d="M191.211 29.167h-53.434l-14.45 100.875h56.214c39.637 0 57.93-22.143 57.93-58.19-.001-27.575-16.572-42.685-46.26-42.685zm-9.548 21.605c17.104 0 23.333 7.952 23.333 22.803 0 21.338-9.811 34.327-30.498 34.327h-16.167l8.224-57.128h15.108v-.002zm-68.671 52.358c-5.567 1.458-15.377 3.049-26.384 3.049-22.269 0-31.813-9.935-31.813-24.651 0-21.606 17.635-29.828 39.242-29.828 11.53 0 20.683 2.787 23.591 3.719l3.449-23.731c-7.959-1.983-17.24-4.237-34.331-4.237-34.731-.003-65.487 17.227-65.487 54.08 0 28.63 18.429 50.375 56.202 50.375 13.789 0 27.312-2.658 31.947-4.64l3.584-24.136zM289.04 29.167h-33.138l-7.561 51.962c-4.903 33.798 12.189 50.772 47.332 50.772 39.075 0 53.021-20.289 57.393-51.037l7.428-51.697h-31.947l-7.688 53.956c-2.122 14.977-8.893 24.775-22.752 24.775-13.739 0-19.271-8.08-16.745-25.709l7.678-53.022zM605.63 103.138c-5.565 1.455-15.367 3.05-26.354 3.05-22.25 0-31.781-9.928-31.781-24.629 0-21.582 17.613-29.79 39.197-29.79 11.518 0 20.646 2.778 23.569 3.705l3.438-23.702c-7.947-1.978-17.213-4.235-34.294-4.235-34.694 0-65.414 17.218-65.414 54.022 0 28.604 18.396 50.316 56.146 50.316 13.771 0 27.275-2.654 31.912-4.637l3.581-24.1zm40.516 29.389c32.84 0 61.562-11.646 61.562-35.213 0-14.034-12.843-21.571-28.598-27.532l-6.355-2.386c-12.312-4.64-17.348-6.886-17.348-11.651 0-4.767 6.099-7.416 17.614-7.416 13.774 0 23.569 4.232 32.565 8.08l4.104-23.043c-7.14-2.521-19.062-6.621-39.188-6.621-27.4 0-51.116 11.521-51.116 31.645 0 14.171 11.136 21.982 24.503 27.678l5.956 2.52c13.513 5.688 19.465 7.409 19.465 12.583 0 5.021-6.741 8.596-21.706 8.596-14.036 0-24.24-4.097-31.651-7.947l-3.574 24.901c5.291 2.109 15.884 5.806 33.767 5.806zm111.622-103.27h-33.104l-7.559 51.904c-4.898 33.761 12.188 50.712 47.281 50.712 39.035 0 52.962-20.262 57.318-50.976l7.432-51.645H797.22l-7.68 53.896c-2.115 14.959-8.88 24.756-22.729 24.756-13.729 0-19.251-8.077-16.729-25.682l7.686-52.965z"
        fill="#B9B9B9"
        fillRule="nonzero"
      />
    </G>
  </Svg>
);

CduCsu.propTypes = {
  width: PropTypes.number.isRequired,
};

CduCsu.defaultProps = {};

export default CduCsu;
