"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var parseEndpoint_1 = require("./parseEndpoint");
describe('parseEndpoint', function () {
    test('work for minimal url', function () {
        expect(parseEndpoint_1.parseEndpoint('http://localhost:4466')).toMatchSnapshot();
    });
    test('work for url with service', function () {
        expect(parseEndpoint_1.parseEndpoint('http://localhost:4466/service-name')).toMatchSnapshot();
    });
    test('work for url with service and stage', function () {
        expect(parseEndpoint_1.parseEndpoint('http://localhost:4466/service-name/stage')).toMatchSnapshot();
    });
    test('private url', function () {
        expect(parseEndpoint_1.parseEndpoint('https://test1_workspace.prisma.sh/tessst/dev')).toMatchSnapshot();
    });
    test('shared url', function () {
        expect(parseEndpoint_1.parseEndpoint('https://eu1.prisma.sh/workspace-name/tessst/dev')).toMatchSnapshot();
    });
});
//# sourceMappingURL=parseEndpoint.test.js.map