"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
/*
 * Copyright 2011 Atteo.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
var twoFormInflector_1 = require("./twoFormInflector");
var Mode;
(function (Mode) {
    Mode[Mode["ENGLISH_ANGLICIZED"] = 0] = "ENGLISH_ANGLICIZED";
    Mode[Mode["ENGLISH_CLASSICAL"] = 1] = "ENGLISH_CLASSICAL";
})(Mode || (Mode = {}));
var English = /** @class */ (function (_super) {
    __extends(English, _super);
    function English(mode) {
        if (mode === void 0) { mode = Mode.ENGLISH_ANGLICIZED; }
        var _this = _super.call(this) || this;
        _super.prototype.uncountable.call(_this, [
            // 2. Handle words that do not inflect in the plural (such as fish, travois, chassis, nationalities ending
            // endings
            'fish',
            'ois',
            'sheep',
            'deer',
            'pox',
            'itis',
            // words
            'bison',
            'flounder',
            'pliers',
            'bream',
            'gallows',
            'proceedings',
            'breeches',
            'graffiti',
            'rabies',
            'britches',
            'headquarters',
            'salmon',
            'carp',
            'herpes',
            'scissors',
            'chassis',
            'high-jinks',
            'sea-bass',
            'clippers',
            'homework',
            'series',
            'cod',
            'innings',
            'shears',
            'contretemps',
            'jackanapes',
            'species',
            'corps',
            'mackerel',
            'swine',
            'debris',
            'measles',
            'trout',
            'diabetes',
            'mews',
            'tuna',
            'djinn',
            'mumps',
            'whiting',
            'eland',
            'news',
            'wildebeest',
            'elk',
            'pincers',
            'sugar',
        ]);
        // 4. Handle standard irregular plurals (mongooses, oxen, etc.)
        _super.prototype.irregularFromList.call(_this, [
            ['child', 'children'],
            ['ephemeris', 'ephemerides'],
            ['mongoose', 'mongoose'],
            ['mythos', 'mythoi'],
            ['soliloquy', 'soliloquies'],
            ['trilby', 'trilbys'],
            ['genus', 'genera'],
            ['quiz', 'quizzes'],
        ]);
        if (mode === Mode.ENGLISH_ANGLICIZED) {
            // Anglicized plural
            _super.prototype.irregularFromList.call(_this, [
                ['beef', 'beefs'],
                ['brother', 'brothers'],
                ['cos', 'cows'],
                ['genie', 'genies'],
                ['money', 'moneys'],
                ['octopus', 'octopuses'],
                ['opus', 'opuses'],
            ]);
        }
        else if (mode === Mode.ENGLISH_CLASSICAL) {
            // Classical plural
            _super.prototype.irregularFromList.call(_this, [
                ['beef', 'beeves'],
                ['brother', 'brethren'],
                ['cow', 'kine'],
                ['genie', 'genii'],
                ['money', 'monies'],
                ['octopus', 'octopodes'],
                ['opus', 'opera'],
            ]);
        }
        _super.prototype.categoryRule.call(_this, English.CATEGORY_MAN_MANS, '', 's');
        // 5. Handle irregular inflections for common suffixes
        _super.prototype.ruleFromList.call(_this, [
            ['man$', 'men'],
            ['([lm])ouse$', '$1ice'],
            ['tooth$', 'teeth'],
            ['goose$', 'geese'],
            ['foot$', 'feet'],
            ['zoon$', 'zoa'],
            ['([csx])is$', '$1es'],
        ]);
        // 6. Handle fully assimilated classical inflections
        _super.prototype.categoryRule.call(_this, English.CATEGORY_EX_ICES, 'ex', 'ices');
        _super.prototype.categoryRule.call(_this, English.CATEGORY_IX_ICES, 'ix', 'ices');
        _super.prototype.categoryRule.call(_this, English.CATEGORY_UM_A, 'um', 'a');
        _super.prototype.categoryRule.call(_this, English.CATEGORY_ON_A, 'on', 'a');
        _super.prototype.categoryRule.call(_this, English.CATEGORY_A_AE, 'a', 'ae');
        // 7. Handle classical variants of modern inflections
        if (mode === Mode.ENGLISH_CLASSICAL) {
            _super.prototype.ruleFromList.call(_this, [
                ['trix$', 'trices'],
                ['eau$', 'eaux'],
                ['ieu$', 'ieux'],
                ['(..[iay])nx$', '$1nges'],
            ]);
            _super.prototype.categoryRule.call(_this, English.CATEGORY_EN_INA, 'en', 'ina');
            _super.prototype.categoryRule.call(_this, English.CATEGORY_A_ATA, 'a', 'ata');
            _super.prototype.categoryRule.call(_this, English.CATEGORY_IS_IDES, 'is', 'ides');
            _super.prototype.categoryRule.call(_this, English.CATEGORY_US_US, '', '');
            _super.prototype.categoryRule.call(_this, English.CATEGORY_O_I, 'o', 'i');
            _super.prototype.categoryRule.call(_this, English.CATEGORY_NONE_I, '', 'i');
            _super.prototype.categoryRule.call(_this, English.CATEGORY_NONE_IM, '', 'im');
            _super.prototype.categoryRule.call(_this, English.CATEGORY_EX_EXES, 'ex', 'ices');
            _super.prototype.categoryRule.call(_this, English.CATEGORY_IX_IXES, 'ix', 'ices');
        }
        _super.prototype.categoryRule.call(_this, English.CATEGORY_US_I, 'us', 'i');
        _super.prototype.rule.call(_this, '([cs]h|[zx])$', '$1es');
        _super.prototype.categoryRule.call(_this, English.CATEGORY_S_ES, '', 'es');
        _super.prototype.categoryRule.call(_this, English.CATEGORY_IS_IDES, '', 'es');
        _super.prototype.categoryRule.call(_this, English.CATEGORY_US_US, '', 'es');
        _super.prototype.rule.call(_this, '(us)$', '$1es');
        _super.prototype.categoryRule.call(_this, English.CATEGORY_A_ATA, '', 's');
        // The suffixes -ch, -sh, and -ss all take -es in the plural (churches,
        // classes, etc)...
        _super.prototype.ruleFromList.call(_this, [['([cs])h$', '$1hes'], ['ss$', 'sses']]);
        // Certain words ending in -f or -fe take -ves in the plural (lives,
        // wolves, etc)...
        _super.prototype.ruleFromList.call(_this, [
            ['([aeo]l)f$', '$1ves'],
            ['([^d]ea)f$', '$1ves'],
            ['(ar)f$', '$1ves'],
            ['([nlw]i)fe$', '$1ves'],
        ]);
        // Words ending in -y take -ys
        _super.prototype.ruleFromList.call(_this, [['([aeiou])y$', '$1ys'], ['y$', 'ies']]);
        // Some words ending in -o take -os (including does preceded by a vowel)
        _super.prototype.categoryRule.call(_this, English.CATEGORY_O_I, 'o', 'os');
        _super.prototype.categoryRule.call(_this, English.CATEGORY_O_OS, 'o', 'os');
        _super.prototype.rule.call(_this, '([aeiou])o$', '$1os');
        // The rest take -oes
        _super.prototype.rule.call(_this, 'o$', 'oes');
        _super.prototype.rule.call(_this, 'ulum', 'ula');
        _super.prototype.categoryRule.call(_this, English.CATEGORY_A_ATA, '', 'es');
        _super.prototype.rule.call(_this, 's$', 'ses');
        // Otherwise, assume that the plural just adds -s
        _super.prototype.rule.call(_this, '$', 's');
        return _this;
    }
    /**
     * Returns plural form of the given word.
     * <p>
     * For instance:
     * <pre>
     * {@code
     * English.plural("cat") == "cats";
     * }
     * </pre>
     * </p>
     * @param word word in singular form
     * @return plural form of given word
     */
    English.plural = function (word) {
        return English.inflector.getPlural(word);
    };
    /**
     * Returns singular or plural form of the word based on count.
     * <p>
     * For instance:
     * <pre>
     * {@code
     * English.plural("cat", 1) == "cat";
     * English.plural("cat", 2) == "cats";
     * }
     * </pre>
     * </p>
     * @param word word in singular form
     * @param count word count
     * @return form of the word correct for given count
     */
    English.pluralByCount = function (word, count) {
        return English.inflector.getPluralByCount(word, count);
    };
    English.setMode = function (mode) {
        English.inflector = new English(mode);
    };
    /**
     * Returns plural form of the given word.
     *
     * @param word word in singular form
     * @return plural form of the word
     */
    English.prototype.getPlural = function (word) {
        var plural = _super.prototype.getPlural.call(this, word);
        if (plural === word) {
            if (plural.endsWith('s')) {
                return plural + 'es';
            }
            else {
                return plural + 's';
            }
        }
        return plural;
    };
    /**
     * Returns singular or plural form of the word based on count.
     *
     * @param word word in singular form
     * @param count word count
     * @return form of the word correct for given count
     */
    English.prototype.getPluralByCount = function (word, count) {
        if (count === 1) {
            return word;
        }
        return this.getPlural(word);
    };
    English.CATEGORY_EX_ICES = ['codex', 'murex', 'silex'];
    English.CATEGORY_IX_ICES = ['radix', 'helix'];
    English.CATEGORY_UM_A = [
        'bacterium',
        'agendum',
        'desideratum',
        'erratum',
        'stratum',
        'datum',
        'ovum',
        'extremum',
        'candelabrum',
    ];
    English.CATEGORY_US_I = [
        'alumnus',
        'alveolus',
        'bacillus',
        'bronchus',
        'locus',
        'nucleus',
        'stimulus',
        'meniscus',
        'thesaurus',
    ];
    English.CATEGORY_ON_A = [
        'criterion',
        'perihelion',
        'aphelion',
        'phenomenon',
        'prolegomenon',
        'noumenon',
        'organon',
        'asyndeton',
        'hyperbaton',
    ];
    English.CATEGORY_A_AE = ['alumna', 'alga', 'vertebra', 'persona'];
    English.CATEGORY_O_OS = [
        'albino',
        'archipelago',
        'armadillo',
        'commando',
        'crescendo',
        'fiasco',
        'ditto',
        'dynamo',
        'embryo',
        'ghetto',
        'guano',
        'inferno',
        'jumbo',
        'lumbago',
        'magneto',
        'manifesto',
        'medico',
        'octavo',
        'photo',
        'pro',
        'quarto',
        'canto',
        'lingo',
        'generalissimo',
        'stylo',
        'rhino',
        'casino',
        'auto',
        'macro',
        'zero',
    ];
    English.CATEGORY_O_I = [
        'solo',
        'soprano',
        'basso',
        'alto',
        'contralto',
        'tempo',
        'piano',
        'virtuoso',
    ];
    English.CATEGORY_EN_INA = ['stamen', 'foramen', 'lumen'];
    English.CATEGORY_A_ATA = [
        'anathema',
        'enema',
        'oedema',
        'bema',
        'enigma',
        'sarcoma',
        'carcinoma',
        'gumma',
        'schema',
        'charisma',
        'lemma',
        'soma',
        'diploma',
        'lymphoma',
        'stigma',
        'dogma',
        'magma',
        'stoma',
        'drama',
        'melisma',
        'trauma',
        'edema',
        'miasma',
    ];
    English.CATEGORY_IS_IDES = ['iris', 'clitoris'];
    English.CATEGORY_US_US = [
        'apparatus',
        'impetus',
        'prospectus',
        'cantus',
        'nexus',
        'sinus',
        'coitus',
        'plexus',
        'status',
        'hiatus',
    ];
    English.CATEGORY_NONE_I = ['afreet', 'afrit', 'efreet'];
    English.CATEGORY_NONE_IM = ['cherub', 'goy', 'seraph'];
    English.CATEGORY_EX_EXES = [
        'apex',
        'latex',
        'vertex',
        'cortex',
        'pontifex',
        'vortex',
        'index',
        'simplex',
    ];
    English.CATEGORY_IX_IXES = ['appendix'];
    English.CATEGORY_S_ES = [
        'acropolis',
        'chaos',
        'lens',
        'aegis',
        'cosmos',
        'mantis',
        'alias',
        'dais',
        'marquis',
        'asbestos',
        'digitalis',
        'metropolis',
        'atlas',
        'epidermis',
        'pathos',
        'bathos',
        'ethos',
        'pelvis',
        'bias',
        'gas',
        'polis',
        'caddis',
        'glottis',
        'rhinoceros',
        'cannabis',
        'glottis',
        'sassafras',
        'canvas',
        'ibis',
        'trellis',
    ];
    English.CATEGORY_MAN_MANS = [
        'human',
        'Alabaman',
        'Bahaman',
        'Burman',
        'German',
        'Hiroshiman',
        'Liman',
        'Nakayaman',
        'Oklahoman',
        'Panaman',
        'Selman',
        'Sonaman',
        'Tacoman',
        'Yakiman',
        'Yokohaman',
        'Yuman',
    ];
    English.inflector = new English();
    return English;
}(twoFormInflector_1.TwoFormInflector));
exports.English = English;
//# sourceMappingURL=english.js.map