import { TwoFormInflector } from './twoFormInflector';
declare enum Mode {
    ENGLISH_ANGLICIZED = 0,
    ENGLISH_CLASSICAL = 1
}
export declare class English extends TwoFormInflector {
    /**
     * Returns plural form of the given word.
     * <p>
     * For instance:
     * <pre>
     * {@code
     * English.plural("cat") == "cats";
     * }
     * </pre>
     * </p>
     * @param word word in singular form
     * @return plural form of given word
     */
    static plural(word: string): string | null;
    /**
     * Returns singular or plural form of the word based on count.
     * <p>
     * For instance:
     * <pre>
     * {@code
     * English.plural("cat", 1) == "cat";
     * English.plural("cat", 2) == "cats";
     * }
     * </pre>
     * </p>
     * @param word word in singular form
     * @param count word count
     * @return form of the word correct for given count
     */
    static pluralByCount(word: string, count: number): string | null;
    static setMode(mode: Mode): void;
    private static CATEGORY_EX_ICES;
    private static CATEGORY_IX_ICES;
    private static CATEGORY_UM_A;
    private static CATEGORY_US_I;
    private static CATEGORY_ON_A;
    private static CATEGORY_A_AE;
    private static CATEGORY_O_OS;
    private static CATEGORY_O_I;
    private static CATEGORY_EN_INA;
    private static CATEGORY_A_ATA;
    private static CATEGORY_IS_IDES;
    private static CATEGORY_US_US;
    private static CATEGORY_NONE_I;
    private static CATEGORY_NONE_IM;
    private static CATEGORY_EX_EXES;
    private static CATEGORY_IX_IXES;
    private static CATEGORY_S_ES;
    private static CATEGORY_MAN_MANS;
    private static inflector;
    constructor(mode?: Mode);
    /**
     * Returns plural form of the given word.
     *
     * @param word word in singular form
     * @return plural form of the word
     */
    getPlural(word: string): string | null;
    /**
     * Returns singular or plural form of the word based on count.
     *
     * @param word word in singular form
     * @param count word count
     * @return form of the word correct for given count
     */
    getPluralByCount(word: string, count: number): string | null;
}
export {};
