import { ISDL, IGQLType, IDirectiveInfo, IGQLField } from "../model";
export default class Renderer {
    render(input: ISDL): string;
    protected renderType(type: IGQLType): string;
    protected renderComments(type: IGQLType | IGQLField, spacing: string): {
        renderedComments: string | never[];
        hasError: boolean;
    };
    protected renderField(field: IGQLField): string;
    protected renderEnum(type: IGQLType): string;
    protected renderDirectives(directives: IDirectiveInfo[]): string;
    protected renderDirective(directive: IDirectiveInfo): string;
    /**
     * Merges directives by summarizing arguments of
     * directives with equal name.
     */
    protected mergeDirectives(directives: IDirectiveInfo[]): IDirectiveInfo[];
    protected extractTypeIdentifier(type: string | IGQLType): string;
    protected renderValue(type: string | IGQLType, value: any): any;
}
