"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var parser_1 = require("./parser");
exports.idFieldName = 'id';
exports.createdAtFieldName = 'createdAt';
exports.updatedAtFieldName = 'updatedAt';
/**
 * Parser implementation for related models.
 */
var RelationalParser = /** @class */ (function (_super) {
    __extends(RelationalParser, _super);
    function RelationalParser() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    RelationalParser.prototype.isIdField = function (field) {
        return field.name.value === exports.idFieldName;
    };
    RelationalParser.prototype.isReadOnly = function (field) {
        return field.name.value === exports.idFieldName ||
            field.name.value === exports.createdAtFieldName ||
            field.name.value === exports.updatedAtFieldName;
    };
    RelationalParser.prototype.isEmbedded = function (type) {
        // Related models are never embedded
        return false;
    };
    return RelationalParser;
}(parser_1.default));
exports.default = RelationalParser;
//# sourceMappingURL=relationalParser.js.map