import { Output, Client, Config } from 'prisma-cli-engine';
import { Cluster, Environment, PrismaDefinitionClass } from 'prisma-yml';
import { MongoClient } from 'mongodb';
export interface GetEndpointParams {
    folderName: string;
}
export declare type DatabaseType = 'postgres' | 'mysql' | 'mongo';
export interface DatabaseCredentials {
    type: DatabaseType;
    host?: string;
    port?: number;
    user?: string;
    password?: string;
    database?: string;
    alreadyData?: boolean;
    schema?: string;
    ssl?: boolean;
    uri?: string;
}
export interface GetEndpointResult {
    endpoint: string;
    cluster: Cluster | undefined;
    workspace: string | undefined;
    service: string;
    stage: string;
    localClusterRunning: boolean;
    database?: DatabaseCredentials;
    dockerComposeYml: string;
    datamodel: string;
    newDatabase: boolean;
    managementSecret?: string;
    writeDockerComposeYml: boolean;
    generator?: string;
}
export interface HandleChoiceInput {
    choice: string;
    loggedIn: boolean;
    folderName: string;
    localClusterRunning: boolean;
    clusters?: Cluster[];
}
export interface ConstructorArgs {
    out: Output;
    client: Client;
    env: Environment;
    config: Config;
    definition: PrismaDefinitionClass;
    shouldAskForGenerator: boolean;
}
export declare class EndpointDialog {
    out: Output;
    client: Client;
    env: Environment;
    config: Config;
    definition: PrismaDefinitionClass;
    shouldAskForGenerator: boolean;
    constructor({ out, client, env, config, definition, shouldAskForGenerator, }: ConstructorArgs);
    getEndpoint(): Promise<GetEndpointResult>;
    encodeName(name: any): any;
    decodeName(name: any): any;
    printDatabaseConfig(credentials: DatabaseCredentials): any;
    printDatabaseService(type: DatabaseType): string;
    handleChoice({ choice, loggedIn, folderName, localClusterRunning, clusters, }: HandleChoiceInput): Promise<GetEndpointResult>;
    connectToMongo(credentials: DatabaseCredentials): Promise<MongoClient>;
    replaceLocalDockerHost(credentials: DatabaseCredentials): DatabaseCredentials | {
        host: any;
        type: DatabaseType;
        port?: number | undefined;
        user?: string | undefined;
        password?: string | undefined;
        database?: string | undefined;
        alreadyData?: boolean | undefined;
        schema?: string | undefined;
        ssl?: boolean | undefined;
        uri?: string | undefined;
    };
    replaceMongoHost(connectionString: string): string;
    getDatabase(introspection?: boolean): Promise<DatabaseCredentials>;
    selectSchema(schemas: string[]): Promise<string>;
    private getClusterAndWorkspaceFromChoice;
    private getCloudClusters;
    private projectExists;
    private listFiles;
    private isClusterOnline;
    private getClusterQuestion;
    private getClusterName;
    private getClusterChoice;
    private getDemoCluster;
    private askForDemoCluster;
    private getClusterDescription;
    private askForDatabaseType;
    private convertChoices;
    private askForStage;
    private askForGenerator;
    private askForService;
    private customEndpointSelector;
    private askForExistingDataMongo;
    private askForExistingData;
    private ask;
    private getSillyName;
    private getPublicName;
}
