"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var _a;
var prisma_cli_engine_1 = require("prisma-cli-engine");
var EndpointDialog_1 = require("../../utils/EndpointDialog");
var prisma_db_introspection_1 = require("prisma-db-introspection");
var path = require("path");
var fs = require("fs");
var util_1 = require("../../util");
var chalk_1 = require("chalk");
var pg_1 = require("pg");
var mongodb_1 = require("mongodb");
var IntrospectCommand = /** @class */ (function (_super) {
    __extends(IntrospectCommand, _super);
    function IntrospectCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    IntrospectCommand.prototype.run = function () {
        return __awaiter(this, void 0, void 0, function () {
            var interactive, pgHost, pgPort, pgUser, pgPassword, pgDb, pgSsl, pgSchema, mongoUri, mongoDb, endpointDialog, client, connector, requiredPostgresArgs, pgArgsEntries, notProvidedArgs, service, stage, cluster, workspace, credentials, schemas, before, e_1, schema, exists, schemaName, exists, _a, introspection, sdl, numTables, renderedSdl, fileName, fullFileName;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        interactive = this.flags.interactive;
                        pgHost = this.flags['pg-host'];
                        pgPort = this.flags['pg-port'];
                        pgUser = this.flags['pg-user'];
                        pgPassword = this.flags['pg-password'];
                        pgDb = this.flags['pg-db'];
                        pgSsl = this.flags['pg-ssl'];
                        pgSchema = this.flags['pg-schema'];
                        mongoUri = this.flags['mongo-uri'];
                        mongoDb = this.flags['mongo-db'];
                        endpointDialog = new EndpointDialog_1.EndpointDialog({
                            out: this.out,
                            client: this.client,
                            env: this.env,
                            config: this.config,
                            definition: this.definition,
                            shouldAskForGenerator: false,
                        });
                        /**
                         * Handle MongoDB CLI args
                         */
                        if (mongoUri && !mongoDb) {
                            throw new Error("You provided mongo-uri, but not the required option mongo-db");
                        }
                        if (mongoDb && !mongoUri) {
                            throw new Error("You provided mongo-db, but not the required option mongo-uri");
                        }
                        if (!(mongoDb && mongoUri)) return [3 /*break*/, 2];
                        return [4 /*yield*/, this.connectToMongo({
                                type: 'mongo',
                                uri: mongoUri,
                                database: mongoDb,
                            })];
                    case 1:
                        client = _b.sent();
                        connector = new prisma_db_introspection_1.MongoConnector(client);
                        _b.label = 2;
                    case 2:
                        requiredPostgresArgs = {
                            'pg-host': pgHost,
                            'pg-user': pgUser,
                            'pg-password': pgPassword,
                            'pg-db': pgDb,
                            'pg-schema': pgSchema,
                        };
                        pgArgsEntries = Object.entries(requiredPostgresArgs);
                        notProvidedArgs = pgArgsEntries.filter(function (_a) {
                            var _ = _a[0], value = _a[1];
                            return !value;
                        });
                        if (notProvidedArgs.length > 0 &&
                            notProvidedArgs.length < pgArgsEntries.length) {
                            console.log({
                                pgArgsEntriesLength: pgArgsEntries.length,
                                notProvidedArgsLength: notProvidedArgs.length,
                            });
                            throw new Error("If you provide one of the pg- arguments, you need to provide all of them. The arguments " + notProvidedArgs
                                .map(function (_a) {
                                var k = _a[0];
                                return k;
                            })
                                .join(', ') + " are missing.");
                        }
                        if (notProvidedArgs.length === 0) {
                            client = new pg_1.Client({
                                host: pgHost,
                                port: parseInt(pgPort, 10),
                                user: pgUser,
                                password: pgPassword,
                                database: pgDb,
                                ssl: pgSsl,
                            });
                            connector = new prisma_db_introspection_1.PostgresConnector(client);
                        }
                        if (!!interactive) return [3 /*break*/, 6];
                        return [4 /*yield*/, this.definition.load(this.flags)];
                    case 3:
                        _b.sent();
                        service = this.definition.service;
                        stage = this.definition.stage;
                        cluster = this.definition.getCluster();
                        workspace = this.definition.getWorkspace();
                        this.env.setActiveCluster(cluster);
                        return [4 /*yield*/, this.client.initClusterClient(cluster, service, stage, workspace)];
                    case 4:
                        _b.sent();
                        return [4 /*yield*/, this.hasExecuteRaw()];
                    case 5:
                        if (_b.sent()) {
                            client = new prisma_db_introspection_1.PrismaDBClient(this.definition);
                            connector = new prisma_db_introspection_1.PostgresConnector(client);
                        }
                        _b.label = 6;
                    case 6:
                        if (!(!client || !connector)) return [3 /*break*/, 10];
                        return [4 /*yield*/, endpointDialog.getDatabase(true)];
                    case 7:
                        credentials = _b.sent();
                        if (!(credentials.type === 'postgres')) return [3 /*break*/, 8];
                        client = new pg_1.Client(credentials);
                        connector = new prisma_db_introspection_1.PostgresConnector(client);
                        return [3 /*break*/, 10];
                    case 8:
                        if (!(credentials.type === 'mongo')) return [3 /*break*/, 10];
                        return [4 /*yield*/, this.connectToMongo(credentials)];
                    case 9:
                        client = _b.sent();
                        connector = new prisma_db_introspection_1.MongoConnector(client);
                        _b.label = 10;
                    case 10:
                        before = Date.now();
                        _b.label = 11;
                    case 11:
                        _b.trys.push([11, 13, , 14]);
                        return [4 /*yield*/, connector.listSchemas()];
                    case 12:
                        schemas = _b.sent();
                        return [3 /*break*/, 14];
                    case 13:
                        e_1 = _b.sent();
                        throw new Error("Could not connect to database. " + e_1.message);
                    case 14:
                        if (!(schemas && schemas.length > 0)) return [3 /*break*/, 28];
                        schema = void 0;
                        if (!(schemas.length === 1)) return [3 /*break*/, 15];
                        schema = schemas[0];
                        return [3 /*break*/, 21];
                    case 15:
                        if (!pgSchema) return [3 /*break*/, 16];
                        exists = schemas.includes(pgSchema);
                        if (!exists) {
                            throw new Error("The provided Postgres Schema " + pgSchema + " does not exist. Choose one of " + schemas.join(', '));
                        }
                        schema = pgSchema;
                        return [3 /*break*/, 21];
                    case 16:
                        if (!mongoDb) return [3 /*break*/, 17];
                        if (!schemas.includes(mongoDb)) {
                            throw new Error("The provided Mongo Databse " + mongoDb + " does not exist. Choose one of " + schemas.join(', '));
                        }
                        schema = mongoDb;
                        return [3 /*break*/, 21];
                    case 17:
                        schemaName = this.definition.service + "$" + this.definition.stage;
                        exists = schemas.includes(schemaName);
                        if (!exists) return [3 /*break*/, 18];
                        _a = schemaName;
                        return [3 /*break*/, 20];
                    case 18: return [4 /*yield*/, endpointDialog.selectSchema(schemas.filter(function (s) { return !s.startsWith('prisma-temporary-introspection-service$'); }))];
                    case 19:
                        _a = _b.sent();
                        _b.label = 20;
                    case 20:
                        schema = _a;
                        _b.label = 21;
                    case 21:
                        this.out.action.start("Introspecting schema " + chalk_1.default.bold(schema));
                        return [4 /*yield*/, connector.introspect(schema)];
                    case 22:
                        introspection = _b.sent();
                        return [4 /*yield*/, introspection.getDatamodel()];
                    case 23:
                        sdl = _b.sent();
                        numTables = sdl.types.length;
                        renderedSdl = introspection.renderer.render(sdl);
                        if (!(typeof client.close === 'function')) return [3 /*break*/, 25];
                        return [4 /*yield*/, client.close()];
                    case 24:
                        _b.sent();
                        return [3 /*break*/, 27];
                    case 25: return [4 /*yield*/, client.end()];
                    case 26:
                        _b.sent();
                        _b.label = 27;
                    case 27:
                        if (numTables === 0) {
                            this.out.log(chalk_1.default.red("\n" + chalk_1.default.bold('Error: ') + "The provided database doesn't contain any tables. Please provide another database."));
                            this.out.exit(1);
                        }
                        fileName = "datamodel-" + new Date().getTime() + ".prisma";
                        fullFileName = path.join(this.config.definitionDir, fileName);
                        fs.writeFileSync(fullFileName, renderedSdl);
                        this.out.action.stop(util_1.prettyTime(Date.now() - before));
                        this.out.log("Created datamodel definition based on " + numTables + " database tables.");
                        this.out.log(chalk_1.default.bold('Created 1 new file:') + "    GraphQL SDL-based datamodel (derived from existing database)\n\n  " + chalk_1.default.cyan(fileName) + "\n");
                        if (!this.definition.definition.datamodel) {
                            this.definition.addDatamodel(fileName);
                            this.out.log("Added " + chalk_1.default.bold("datamodel: " + fileName) + " to prisma.yml");
                        }
                        return [3 /*break*/, 29];
                    case 28: throw new Error("Could not find schema in provided database.");
                    case 29: return [2 /*return*/];
                }
            });
        });
    };
    IntrospectCommand.prototype.hasExecuteRaw = function () {
        return __awaiter(this, void 0, void 0, function () {
            var service, stage, token, workspace, introspection, introspectionString, e_2;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 2, , 3]);
                        service = this.definition.service;
                        stage = this.definition.stage;
                        token = this.definition.getToken(service, stage);
                        workspace = this.definition.getWorkspace();
                        return [4 /*yield*/, this.client.introspect(service, stage, token, workspace)];
                    case 1:
                        introspection = _a.sent();
                        introspectionString = JSON.stringify(introspection);
                        return [2 /*return*/, introspectionString.includes('executeRaw')];
                    case 2:
                        e_2 = _a.sent();
                        return [2 /*return*/, false];
                    case 3: return [2 /*return*/];
                }
            });
        });
    };
    IntrospectCommand.prototype.connectToMongo = function (credentials) {
        return new Promise(function (resolve, reject) {
            if (!credentials.uri) {
                throw new Error("Please provide the MongoDB connection string");
            }
            mongodb_1.MongoClient.connect(credentials.uri, { useNewUrlParser: true }, function (err, client) {
                if (err) {
                    reject(err);
                }
                else {
                    if (credentials.database) {
                        client.db(credentials.database);
                    }
                    resolve(client);
                }
            });
        });
    };
    IntrospectCommand.topic = 'introspect';
    IntrospectCommand.description = 'Introspect database schema(s) of service';
    IntrospectCommand.flags = (_a = {
            interactive: prisma_cli_engine_1.flags.boolean({
                char: 'i',
                description: 'Interactive mode',
            })
        },
        /**
         * Postgres Params
         */
        _a['pg-host'] = prisma_cli_engine_1.flags.string({
            description: 'Name of the Postgres host',
        }),
        _a['pg-port'] = prisma_cli_engine_1.flags.string({
            description: 'The Postgres port. Default: 5432',
            defaultValue: '5432',
        }),
        _a['pg-user'] = prisma_cli_engine_1.flags.string({
            description: 'The Postgres user',
        }),
        _a['pg-password'] = prisma_cli_engine_1.flags.string({
            description: 'The Postgres password',
        }),
        _a['pg-db'] = prisma_cli_engine_1.flags.string({
            description: 'The Postgres database',
        }),
        _a['pg-ssl'] = prisma_cli_engine_1.flags.boolean({
            description: 'Enable ssl for postgres',
        }),
        _a['pg-schema'] = prisma_cli_engine_1.flags.string({
            description: 'Name of the Postgres schema',
        }),
        /**
         * Mongo Params
         */
        _a['mongo-uri'] = prisma_cli_engine_1.flags.string({
            description: 'Mongo connection string',
        }),
        _a['mongo-db'] = prisma_cli_engine_1.flags.string({
            description: 'Mongo database',
        }),
        _a);
    IntrospectCommand.hidden = false;
    return IntrospectCommand;
}(prisma_cli_engine_1.Command));
exports.default = IntrospectCommand;
//# sourceMappingURL=introspect.js.map