/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *  strict-local
 * @format
 */

"use strict";
var _extends =
  Object.assign ||
  function(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }
    return target;
  };
let calcTransformerOptions = (() => {
  var _ref = _asyncToGenerator(function*(
    entryFiles,
    bundler,
    deltaBundler,
    config,
    options
  ) {
    const baseOptions = {
      customTransformOptions: options.customTransformOptions,
      dev: options.dev,
      hot: options.hot,
      inlineRequires: false,
      minify: options.minify,
      platform: options.platform
    };

    // When we're processing scripts, we don't need to calculate any
    // inlineRequires information, since scripts by definition don't have
    // requires().
    if (options.type === "script") {
      return _extends({}, baseOptions, {
        type: "script"
      });
    }

    const getDependencies = (() => {
      var _ref2 = _asyncToGenerator(function*(path) {
        var _ref3 = yield deltaBundler.buildGraph([path], {
          resolve: yield getResolveDependencyFn(bundler, options.platform),
          transform: yield getTransformFn(
            [path],
            bundler,
            deltaBundler,
            config,
            _extends({}, options, {
              minify: false
            })
          ),

          onProgress: null
        });
        const dependencies = _ref3.dependencies;

        return Array.from(dependencies.keys());
      });
      return function getDependencies(_x6) {
        return _ref2.apply(this, arguments);
      };
    })();
    var _ref4 = yield config.transformer.getTransformOptions(
      entryFiles,
      { dev: options.dev, hot: options.hot, platform: options.platform },
      getDependencies
    );
    const transform = _ref4.transform;

    return _extends({}, baseOptions, {
      inlineRequires: transform.inlineRequires || false,
      experimentalImportSupport: transform.experimentalImportSupport || false,
      type: "module"
    });
  });
  return function calcTransformerOptions(_x, _x2, _x3, _x4, _x5) {
    return _ref.apply(this, arguments);
  };
})();
let getTransformFn = (() => {
  var _ref5 = _asyncToGenerator(function*(
    entryFiles,
    bundler,
    deltaBundler,
    config,
    options
  ) {
    var _ref6 = yield calcTransformerOptions(
      entryFiles,
      bundler,
      deltaBundler,
      config,
      options
    );
    const inlineRequires = _ref6.inlineRequires,
      transformOptions = _objectWithoutProperties(_ref6, ["inlineRequires"]);

    return (() => {
      var _ref7 = _asyncToGenerator(function*(path) {
        return yield bundler.transformFile(
          path,
          _extends({}, transformOptions, {
            type: getType(
              transformOptions.type,
              path,
              config.resolver.assetExts
            ),
            inlineRequires: removeInlineRequiresBlacklistFromOptions(
              path,
              inlineRequires
            )
          })
        );
      });
      return function(_x12) {
        return _ref7.apply(this, arguments);
      };
    })();
  });
  return function getTransformFn(_x7, _x8, _x9, _x10, _x11) {
    return _ref5.apply(this, arguments);
  };
})();
let getResolveDependencyFn = (() => {
  var _ref8 = _asyncToGenerator(function*(bundler, platform) {
    const dependencyGraph = yield bundler.getDependencyGraph();

    return function(from, to) {
      return dependencyGraph.resolveDependency(from, to, platform);
    };
  });
  return function getResolveDependencyFn(_x13, _x14) {
    return _ref8.apply(this, arguments);
  };
})();
function _objectWithoutProperties(obj, keys) {
  var target = {};
  for (var i in obj) {
    if (keys.indexOf(i) >= 0) continue;
    if (!Object.prototype.hasOwnProperty.call(obj, i)) continue;
    target[i] = obj[i];
  }
  return target;
}
function _asyncToGenerator(fn) {
  return function() {
    var gen = fn.apply(this, arguments);
    return new Promise(function(resolve, reject) {
      function step(key, arg) {
        try {
          var info = gen[key](arg);
          var value = info.value;
        } catch (error) {
          reject(error);
          return;
        }
        if (info.done) {
          resolve(value);
        } else {
          return Promise.resolve(value).then(
            function(value) {
              step("next", value);
            },
            function(err) {
              step("throw", err);
            }
          );
        }
      }
      return step("next");
    });
  };
}
const path = require("path");
function removeInlineRequiresBlacklistFromOptions(path, inlineRequires) {
  if (typeof inlineRequires === "object") {
    return !(path in inlineRequires.blacklist);
  }
  return inlineRequires;
}
function getType(type, filePath, assetExts) {
  if (type === "script") {
    return type;
  }
  if (assetExts.indexOf(path.extname(filePath).slice(1)) !== -1) {
    return "asset";
  }
  return "module";
}

module.exports = {
  getTransformFn,
  getResolveDependencyFn
};
