/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *  strict-local
 * @format
 */

"use strict";
var _extends =
  Object.assign ||
  function(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }
    return target;
  };
let getPrependedScripts = (() => {
  var _ref = _asyncToGenerator(function*(
    config,
    options,
    bundler,
    deltaBundler
  ) {
    // Get all the polyfills from the relevant option params (the
    // `getPolyfills()` method and the `polyfillModuleNames` variable).
    const polyfillModuleNames = config.serializer
      .getPolyfills({
        platform: options.platform
      })
      .concat(config.serializer.polyfillModuleNames);

    const transformOptions = _extends({}, options, {
      type: "script"
    });

    const graph = yield deltaBundler.buildGraph(
      [defaults.moduleSystem].concat(_toConsumableArray(polyfillModuleNames)),
      {
        resolve: yield transformHelpers.getResolveDependencyFn(
          bundler,
          options.platform
        ),

        transform: yield transformHelpers.getTransformFn(
          [defaults.moduleSystem].concat(
            _toConsumableArray(polyfillModuleNames)
          ),
          bundler,
          deltaBundler,
          config,
          transformOptions
        ),

        onProgress: null
      }
    );

    return [_getPrelude({ dev: options.dev })].concat(
      _toConsumableArray(graph.dependencies.values())
    );
  });
  return function getPrependedScripts(_x, _x2, _x3, _x4) {
    return _ref.apply(this, arguments);
  };
})();
function _toConsumableArray(arr) {
  if (Array.isArray(arr)) {
    for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++)
      arr2[i] = arr[i];
    return arr2;
  } else {
    return Array.from(arr);
  }
}
function _asyncToGenerator(fn) {
  return function() {
    var gen = fn.apply(this, arguments);
    return new Promise(function(resolve, reject) {
      function step(key, arg) {
        try {
          var info = gen[key](arg);
          var value = info.value;
        } catch (error) {
          reject(error);
          return;
        }
        if (info.done) {
          resolve(value);
        } else {
          return Promise.resolve(value).then(
            function(value) {
              step("next", value);
            },
            function(err) {
              step("throw", err);
            }
          );
        }
      }
      return step("next");
    });
  };
}
const defaults = require("metro-config/src/defaults/defaults");
const getPreludeCode = require("./getPreludeCode");
const transformHelpers = require("./transformHelpers");

function _getPrelude(_ref2) {
  let dev = _ref2.dev;
  const code = getPreludeCode({ isDev: dev });
  const name = "__prelude__";

  return {
    dependencies: new Map(),
    getSource: () => Buffer.from(code),
    inverseDependencies: new Set(),
    path: name,
    output: [
      {
        type: "js/script/virtual",
        data: {
          code,
          map: []
        }
      }
    ]
  };
}

module.exports = getPrependedScripts;
