/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *
 * @format
 */

"use strict";
var _extends =
  Object.assign ||
  function(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }
    return target;
  };
let getConfig = (() => {
  var _ref = _asyncToGenerator(function*(config) {
    const defaultConfig = yield getDefaultConfig(config.projectRoot);
    return mergeConfig(defaultConfig, config);
  });
  return function getConfig(_x) {
    return _ref.apply(this, arguments);
  };
})();
let runMetro = (() => {
  var _ref2 = _asyncToGenerator(function*(config) {
    const mergedConfig = yield getConfig(config);

    mergedConfig.reporter.update({
      type: "initialize_started",
      port: mergedConfig.server.port,
      // FIXME: We need to change that to watchFolders. It will be a
      // breaking since it affects custom reporter API.
      projectRoots: mergedConfig.watchFolders
    });

    return new MetroServer(mergedConfig);
  });
  return function runMetro(_x2) {
    return _ref2.apply(this, arguments);
  };
})();
function _asyncToGenerator(fn) {
  return function() {
    var gen = fn.apply(this, arguments);
    return new Promise(function(resolve, reject) {
      function step(key, arg) {
        try {
          var info = gen[key](arg);
          var value = info.value;
        } catch (error) {
          reject(error);
          return;
        }
        if (info.done) {
          resolve(value);
        } else {
          return Promise.resolve(value).then(
            function(value) {
              step("next", value);
            },
            function(err) {
              step("throw", err);
            }
          );
        }
      }
      return step("next");
    });
  };
}
const IncrementalBundler = require("./IncrementalBundler");
const MetroHmrServer = require("./HmrServer");
const MetroServer = require("./Server");
const attachWebsocketServer = require("./lib/attachWebsocketServer");
const http = require("http");
const https = require("https");
const makeBuildCommand = require("./commands/build");
const makeServeCommand = require("./commands/serve");
const outputBundle = require("./shared/output/bundle");
var _require = require("fs-extra");
const readFile = _require.readFile;
var _require2 = require("metro-config");
const loadConfig = _require2.loadConfig,
  mergeConfig = _require2.mergeConfig,
  getDefaultConfig = _require2.getDefaultConfig;

exports.runMetro = runMetro;
exports.loadConfig = loadConfig;

exports.createConnectMiddleware = (() => {
  var _ref3 = _asyncToGenerator(function*(config) {
    const metroServer = yield runMetro(config);

    let enhancedMiddleware = metroServer.processRequest;

    // Enhance the resulting middleware using the config options
    if (config.server.enhanceMiddleware) {
      enhancedMiddleware = config.server.enhanceMiddleware(
        enhancedMiddleware,
        metroServer
      );
    }

    return {
      attachHmrServer(httpServer) {
        attachWebsocketServer({
          httpServer,
          path: "/hot",
          websocketServer: new MetroHmrServer(
            metroServer.getBundler(),
            metroServer.getCreateModuleId(),
            config
          )
        });
      },
      metroServer,
      middleware: enhancedMiddleware,
      end() {
        metroServer.end();
      }
    };
  });
  return function(_x3) {
    return _ref3.apply(this, arguments);
  };
})();

exports.runServer = (() => {
  var _ref4 = _asyncToGenerator(function*(config, _ref5) {
    let host = _ref5.host,
      onReady = _ref5.onReady,
      onError = _ref5.onError;
    var _ref5$secure = _ref5.secure;
    let secure = _ref5$secure === undefined ? false : _ref5$secure,
      secureKey = _ref5.secureKey,
      secureCert = _ref5.secureCert;
    var _ref5$hmrEnabled = _ref5.hmrEnabled;
    let hmrEnabled = _ref5$hmrEnabled === undefined ? false : _ref5$hmrEnabled;
    // Lazy require
    const connect = require("connect");

    const serverApp = connect();
    var _ref6 = yield exports.createConnectMiddleware(config);
    const attachHmrServer = _ref6.attachHmrServer,
      middleware = _ref6.middleware,
      metroServer = _ref6.metroServer,
      end = _ref6.end;

    serverApp.use(middleware);

    if (config.server.enableVisualizer) {
      let initializeVisualizerMiddleware;
      try {
        var _require3 = require("metro-visualizer"); // eslint-disable-next-line import/no-extraneous-dependencies
        initializeVisualizerMiddleware =
          _require3.initializeVisualizerMiddleware;
      } catch (e) {
        console.warn(
          "'config.server.enableVisualizer' is enabled but the 'metro-visualizer' package was not found - have you installed it?"
        );
      }
      if (initializeVisualizerMiddleware) {
        serverApp.use(
          "/visualizer",
          initializeVisualizerMiddleware(metroServer)
        );
      }
    }

    let httpServer;

    if (secure) {
      httpServer = https.createServer(
        {
          key: yield readFile(secureKey),
          cert: yield readFile(secureCert)
        },

        serverApp
      );
    } else {
      httpServer = http.createServer(serverApp);
    }

    httpServer.on("error", function(error) {
      onError && onError(error);
      end();
    });

    if (hmrEnabled) {
      attachHmrServer(httpServer);
    }

    return new Promise(function(resolve, reject) {
      httpServer.listen(config.server.port, host, function() {
        onReady && onReady(httpServer);
        resolve(httpServer);
      });

      // Disable any kind of automatic timeout behavior for incoming
      // requests in case it takes the packager more than the default
      // timeout of 120 seconds to respond to a request.
      httpServer.timeout = 0;

      httpServer.on("error", function(error) {
        end();
        reject(error);
      });

      httpServer.on("close", function() {
        end();
      });
    });
  });
  return function(_x4, _x5) {
    return _ref4.apply(this, arguments);
  };
})();

exports.runBuild = (() => {
  var _ref7 = _asyncToGenerator(function*(config, _ref8) {
    var _ref8$dev = _ref8.dev;
    let dev = _ref8$dev === undefined ? false : _ref8$dev,
      entry = _ref8.entry,
      onBegin = _ref8.onBegin,
      onComplete = _ref8.onComplete,
      onProgress = _ref8.onProgress;
    var _ref8$minify = _ref8.minify;
    let minify = _ref8$minify === undefined ? true : _ref8$minify;
    var _ref8$output = _ref8.output;
    let output = _ref8$output === undefined ? outputBundle : _ref8$output,
      out = _ref8.out;
    var _ref8$platform = _ref8.platform;
    let platform = _ref8$platform === undefined ? "web" : _ref8$platform;
    var _ref8$sourceMap = _ref8.sourceMap;
    let sourceMap = _ref8$sourceMap === undefined ? false : _ref8$sourceMap,
      sourceMapUrl = _ref8.sourceMapUrl;
    const metroServer = yield runMetro(config);

    try {
      const requestOptions = {
        dev,
        entryFile: entry,
        inlineSourceMap: sourceMap && !sourceMapUrl,
        minify,
        platform,
        sourceMapUrl: sourceMap === false ? undefined : sourceMapUrl,
        createModuleIdFactory: config.serializer.createModuleIdFactory,
        onProgress
      };

      if (onBegin) {
        onBegin();
      }

      const metroBundle = yield output.build(metroServer, requestOptions);

      if (onComplete) {
        onComplete();
      }

      if (out) {
        const bundleOutput = out.replace(/(\.js)?$/, ".js");
        const sourcemapOutput =
          sourceMap === false ? undefined : out.replace(/(\.js)?$/, ".map");

        const outputOptions = {
          bundleOutput,
          sourcemapOutput,
          dev,
          platform
        };

        // eslint-disable-next-line no-console
        yield output.save(metroBundle, outputOptions, console.log);
      }

      return metroBundle;
    } finally {
      yield metroServer.end();
    }
  });
  return function(_x6, _x7) {
    return _ref7.apply(this, arguments);
  };
})();

exports.buildGraph = (() => {
  var _ref9 = _asyncToGenerator(function*(config, _ref10) {
    var _ref10$customTransfor = _ref10.customTransformOptions;
    let customTransformOptions =
      _ref10$customTransfor === undefined
        ? Object.create(null)
        : _ref10$customTransfor;
    var _ref10$dev = _ref10.dev;
    let dev = _ref10$dev === undefined ? false : _ref10$dev,
      entries = _ref10.entries;
    var _ref10$minify = _ref10.minify;
    let minify = _ref10$minify === undefined ? false : _ref10$minify,
      onProgress = _ref10.onProgress;
    var _ref10$platform = _ref10.platform;
    let platform = _ref10$platform === undefined ? "web" : _ref10$platform;
    var _ref10$type = _ref10.type;
    let type = _ref10$type === undefined ? "module" : _ref10$type;
    const mergedConfig = yield getConfig(config);

    const bundler = new IncrementalBundler(mergedConfig);

    try {
      return yield bundler.buildGraphForEntries(
        entries,
        _extends({}, MetroServer.DEFAULT_GRAPH_OPTIONS, {
          customTransformOptions,
          dev,
          minify,
          platform,
          type
        })
      );
    } finally {
      bundler.end();
    }
  });
  return function(_x8, _x9) {
    return _ref9.apply(this, arguments);
  };
})();

exports.attachMetroCli = function(yargs) {
  var _ref11 =
      arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
    _ref11$build = _ref11.build;
  let build = _ref11$build === undefined ? {} : _ref11$build;
  var _ref11$serve = _ref11.serve;
  let serve = _ref11$serve === undefined ? {} : _ref11$serve;
  if (build) {
    var _makeBuildCommand = makeBuildCommand();
    const command = _makeBuildCommand.command,
      description = _makeBuildCommand.description,
      builder = _makeBuildCommand.builder,
      handler = _makeBuildCommand.handler;
    yargs.command(command, description, builder, handler);
  }
  if (serve) {
    var _makeServeCommand = makeServeCommand();
    const command = _makeServeCommand.command,
      description = _makeServeCommand.description,
      builder = _makeServeCommand.builder,
      handler = _makeServeCommand.handler;
    yargs.command(command, description, builder, handler);
  }
  return yargs;
};

// The symbols below belong to the legacy API and should not be relied upon
Object.assign(exports, require("./legacy"));
