/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *
 * @format
 */

"use strict";
var _extends =
  Object.assign ||
  function(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }
    return target;
  };
var _slicedToArray = (function() {
  function sliceIterator(arr, i) {
    var _arr = [];
    var _n = true;
    var _d = false;
    var _e = undefined;
    try {
      for (
        var _i = arr[Symbol.iterator](), _s;
        !(_n = (_s = _i.next()).done);
        _n = true
      ) {
        _arr.push(_s.value);
        if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;
      _e = err;
    } finally {
      try {
        if (!_n && _i["return"]) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }
    return _arr;
  }
  return function(arr, i) {
    if (Array.isArray(arr)) {
      return arr;
    } else if (Symbol.iterator in Object(arr)) {
      return sliceIterator(arr, i);
    } else {
      throw new TypeError(
        "Invalid attempt to destructure non-iterable instance"
      );
    }
  };
})();
function _toConsumableArray(arr) {
  if (Array.isArray(arr)) {
    for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++)
      arr2[i] = arr[i];
    return arr2;
  } else {
    return Array.from(arr);
  }
}

const getAppendScripts = require("../../lib/getAppendScripts");
var _require = require("./helpers/js");
const isJsModule = _require.isJsModule,
  wrapModule = _require.wrapModule;

const PRAGMA = "//# offsetTable=";

// TODO(T34761193): This logic is shared across all serializers.
function processModules(modules, _ref) {
  let filter = _ref.filter,
    createModuleId = _ref.createModuleId,
    dev = _ref.dev,
    projectRoot = _ref.projectRoot;
  return new Map(
    []
      .concat(_toConsumableArray(modules))
      .filter(isJsModule)
      .filter(filter)
      .map(module => [
        createModuleId(module.path),
        wrapModule(module, {
          createModuleId,
          dev,
          projectRoot
        })
      ])
  );
}

function generateSource(map, offset) {
  let output = "";
  const table = [];
  for (const _ref2 of map.entries()) {
    var _ref3 = _slicedToArray(_ref2, 2);
    const id = _ref3[0];
    const code = _ref3[1];
    // TODO(T34761233): The offset is redundant since we can retrieve it from
    // the sum of the lengths of all previous modules.
    table.push([id, offset + output.length, code.length]);
    output += code + "\n";
  }
  // Remove the extraneous line break at the end.
  return [table, output.slice(0, -1)];
}

function plainJSBundle(entryPoint, preModules, graph, options) {
  for (const module of graph.dependencies.values()) {
    options.createModuleId(module.path);
  }

  const processModulesOptions = {
    filter: options.processModuleFilter,
    createModuleId: options.createModuleId,
    dev: options.dev,
    projectRoot: options.projectRoot
  };

  let i = -1;
  var _generateSource = generateSource(
      processModules(
        preModules,
        _extends({}, processModulesOptions, {
          createModuleId: () => i--
        })
      ),

      0
    ),
    _generateSource2 = _slicedToArray(_generateSource, 2);
  const pre = _generateSource2[0],
    preCode = _generateSource2[1];
  var _generateSource3 = generateSource(
      processModules(
        [].concat(_toConsumableArray(graph.dependencies.values())),
        processModulesOptions
      ),
      preCode.length + 1
    ),
    _generateSource4 = _slicedToArray(_generateSource3, 2);
  const delta = _generateSource4[0],
    deltaCode = _generateSource4[1];
  var _generateSource5 = generateSource(
      processModules(
        getAppendScripts(entryPoint, preModules, graph, {
          createModuleId: options.createModuleId,
          getRunModuleStatement: options.getRunModuleStatement,
          runBeforeMainModule: options.runBeforeMainModule,
          runModule: options.runModule,
          sourceMapUrl: options.sourceMapUrl,
          inlineSourceMap: options.inlineSourceMap
        }),

        processModulesOptions
      ),

      preCode.length + deltaCode.length + 2
    ),
    _generateSource6 = _slicedToArray(_generateSource5, 2);
  const post = _generateSource6[0],
    postCode = _generateSource6[1];

  return [preCode, deltaCode, postCode]
    .concat(
      _toConsumableArray(
        options.embedDelta
          ? [
              PRAGMA +
                JSON.stringify({ pre, delta, post, id: options.revisionId })
            ]
          : []
      )
    )
    .join("\n");
}

module.exports = plainJSBundle;
