/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *
 * @format
 */
"use strict";
function _asyncToGenerator(fn) {
  return function() {
    var gen = fn.apply(this, arguments);
    return new Promise(function(resolve, reject) {
      function step(key, arg) {
        try {
          var info = gen[key](arg);
          var value = info.value;
        } catch (error) {
          reject(error);
          return;
        }
        if (info.done) {
          resolve(value);
        } else {
          return Promise.resolve(value).then(
            function(value) {
              step("next", value);
            },
            function(err) {
              step("throw", err);
            }
          );
        }
      }
      return step("next");
    });
  };
}

const blacklist = require("./defaults/blacklist");
const os = require("os");
const path = require("path");
var _require = require("./defaults/defaults");
const defaultCreateModuleIdFactory = _require.defaultCreateModuleIdFactory,
  platforms = _require.platforms,
  providesModuleNodeModules = _require.providesModuleNodeModules;
var _require2 = require("metro-cache");
const FileStore = _require2.FileStore;

const DEFAULT = {
  assetRegistryPath: "missing-asset-registry-path",
  enhanceMiddleware: middleware => middleware,
  extraNodeModules: {},
  cacheStores: [
    new FileStore({
      root: path.join(os.tmpdir(), "metro-cache")
    })
  ],

  cacheVersion: "1.0",
  createModuleIdFactory: defaultCreateModuleIdFactory,
  dynamicDepsInPackages: "throwAtRuntime",
  getAsyncRequireModulePath: () => "metro/src/lib/bundle-modules/asyncRequire",
  getAssetExts: () => [],
  getBlacklistRE: () => blacklist(),
  getEnableBabelRCLookup: () => true,
  getPlatforms: () => platforms,
  getPolyfillModuleNames: () => [],
  getProjectRoots: undefined,
  // We assume the default project path is two levels up from
  // node_modules/metro/
  getProjectRoot: () => path.resolve(__dirname, "../../.."),
  getWatchFolders: () => [],
  getProvidesModuleNodeModules: () => providesModuleNodeModules.slice(),
  getRunModuleStatement: moduleId => `__r(${JSON.stringify(moduleId)});`,
  getSourceExts: () => [],
  getTransformModulePath: () => "metro/src/defaultTransformer",
  getTransformOptions: (() => {
    var _ref = _asyncToGenerator(function*() {
      return {
        transform: { experimentalImportSupport: false, inlineRequires: false },
        preloadedModules: false,
        ramGroups: []
      };
    });
    return function getTransformOptions() {
      return _ref.apply(this, arguments);
    };
  })(),

  getPolyfills: () => [],
  getUseGlobalHotkey: () => true,
  postMinifyProcess: x => x,
  postProcessBundleSourcemap: _ref2 => {
    let code = _ref2.code,
      map = _ref2.map,
      outFileName = _ref2.outFileName;
    return { code, map };
  },
  resolveRequest: null,
  getResolverMainFields: () => ["browser", "main"],
  getModulesRunBeforeMainModule: () => [],
  getWorkerPath: () => "metro/src/DeltaBundler/Worker",
  processModuleFilter: module => true,
  transformVariants: () => ({ default: {} })
};

module.exports = {
  DEFAULT
};
