"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) if (e.indexOf(p[i]) < 0)
            t[p[i]] = s[p[i]];
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var apollo_link_1 = require("apollo-link");
var graphql_1 = require("graphql");
var index_1 = require("./index");
var HTTPLinkDataloader = /** @class */ (function (_super) {
    __extends(HTTPLinkDataloader, _super);
    function HTTPLinkDataloader(options) {
        return _super.call(this, HTTPLinkDataloader.createBatchedHttpRequest(options)) || this;
    }
    HTTPLinkDataloader.createBatchedHttpRequest = function (options) {
        var uri = options.uri, rest = __rest(options, ["uri"]);
        var client = new index_1.BatchedGraphQLClient(uri, rest);
        return function (operation) {
            return new apollo_link_1.Observable(function (observer) {
                var _a = operation.getContext(), headers = _a.headers, contextURI = _a.uri;
                var operationName = operation.operationName, variables = operation.variables, query = operation.query;
                if (contextURI) {
                    client.uri = contextURI;
                }
                if (headers) {
                    client.options = __assign({}, client.options, { headers: __assign({}, client.options.headers, headers) });
                }
                client
                    .request(graphql_1.print(query), variables, operationName)
                    .then(function (response) {
                    operation.setContext({ response: response });
                    observer.next({ data: response });
                    observer.complete();
                    return response;
                })
                    .catch(function (err) {
                    if (err.name === 'AbortError') {
                        return;
                    }
                    observer.error(err);
                });
            });
        };
    };
    return HTTPLinkDataloader;
}(apollo_link_1.ApolloLink));
exports.HTTPLinkDataloader = HTTPLinkDataloader;
//# sourceMappingURL=HTTPLinkDataloader.js.map