"use strict";
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = y[op[0] & 2 ? "return" : op[0] ? "throw" : "next"]) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [0, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
require("cross-fetch/polyfill");
var DataLoader = require("dataloader");
var ClientError_1 = require("./ClientError");
var BatchedGraphQLClient = /** @class */ (function () {
    function BatchedGraphQLClient(uri, options) {
        var _this = this;
        this.load = function (keys) { return __awaiter(_this, void 0, void 0, function () {
            var requests, body, response, results, errorIndex, result, errorResult;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        requests = keys.map(function (k) { return JSON.parse(k); });
                        body = JSON.stringify(requests);
                        return [4 /*yield*/, fetch(this.uri, __assign({ method: 'POST' }, this.options, { headers: Object.assign({ 'Content-Type': 'application/json' }, this.options.headers), body: body }))];
                    case 1:
                        response = _a.sent();
                        return [4 /*yield*/, getResults(response)
                            // if it is not an array, there must be an error
                        ];
                    case 2:
                        results = _a.sent();
                        // if it is not an array, there must be an error
                        if (!Array.isArray(results)) {
                            throw new ClientError_1.ClientError(__assign({}, results, { status: response.status }));
                        }
                        // check if there was an error in one of the responses
                        if (!response.ok ||
                            results.some(function (r) { return r.errors !== undefined || r.data === undefined; })) {
                            errorIndex = results.findIndex(function (r) { return r.errors !== undefined || r.data === undefined; });
                            result = results[errorIndex];
                            errorResult = typeof result === 'string' ? { errors: [{ message: result }] } : result;
                            throw new ClientError_1.ClientError(__assign({}, errorResult, { status: response.status }));
                        }
                        return [2 /*return*/, results.map(function (r) { return r.data; })];
                }
            });
        }); };
        this.uri = uri;
        var cache = options && typeof options.cacheResults !== 'undefined'
            ? options.cacheResults
            : false;
        if (options && typeof options.cacheResults !== 'undefined') {
            delete options.cacheResults;
        }
        this.options = options || {};
        this.dataloader = new DataLoader(this.load, { cache: cache });
    }
    BatchedGraphQLClient.prototype.request = function (query, variables, operationName) {
        return __awaiter(this, void 0, void 0, function () {
            var body;
            return __generator(this, function (_a) {
                body = JSON.stringify({
                    query: query,
                    variables: variables ? variables : undefined,
                    operationName: operationName ? operationName : undefined,
                });
                return [2 /*return*/, this.dataloader.load(body)];
            });
        });
    };
    return BatchedGraphQLClient;
}());
exports.BatchedGraphQLClient = BatchedGraphQLClient;
function getResults(response) {
    var contentType = response.headers.get('Content-Type');
    if (contentType && contentType.startsWith('application/json')) {
        return response.json();
    }
    else {
        return response.text();
    }
}
//# sourceMappingURL=BatchedGraphQLClient.js.map