# Contributing to DEMOCRACY

:+1::tada: First off, thanks for taking the time to contribute! :tada::+1:

The following is a set of guidelines for contributing to DEMOCRACY and its packages, which are hosted in the
[demokratie-live Organization](https://github.com/demokratie-live) on GitHub. These are mostly guidelines, not rules.
Use your best judgment, and feel free to propose changes to this document in a pull request.

#### Table Of Contents

[Code of Conduct](#code-of-conduct)

[What should I know before I get started?](#what-should-i-know-before-i-get-started)
  * [Daily Scrum](#daily-scrum)
  * [Developer Hangout](#developer-hangout)

[How Can I Contribute?](#how-can-i-contribute)
  * [Reporting Bugs](#reporting-bugs)
  * [Suggesting Enhancements](#suggesting-enhancements)
  * [Your First Code Contribution](#your-first-code-contribution)
  * [Pull Requests](#pull-requests)

## Code of Conduct

This project and everyone participating in it is governed by the [DEMOCRACY Code of Conduct](CODE_OF_CONDUCT.md).
By participating, you are expected to uphold this code. Please report unacceptable behavior to
[contact@democracy-deutschland.de](mailto:contact@democracy-deutschland.de).

## What should I know before I get started?

Tools we use:
* [Google Calendar](https://calendar.google.com/calendar?cid=ZTQ0NnV1Mmo4Y3B0amJiam4wdm51bDBqdGtAZ3JvdXAuY2FsZW5kYXIuZ29vZ2xlLmNvbQ)
* [Discord](https://discord.gg/Pdu3ZEV)
* Meistertask - please contact us on Discord to get Access

Meitertask Workflow

![MeistertaskWorkflow](https://github.com/demokratie-live/democracy-assets/blob/master/plan/workflow.png)

### Daily Scrum

Every Workday there is a Daily Scrum at 11:00 CET

* Results of the day before? - per Person (Close Task)
* What are you doing next? - per Person
* What should be done and whats most important to do? - Discussion 	

Every Person enters the results of his Work into Meistertask at the end of the day
and creates new Tasks to discuss on the next Daily Scrum. (Open Task)

### Developer Hangout

Every now and then there is a Developer Hangout taking Place to
talk with all interested and contributing Developers about the
latest developments and most important tasks in the future.

## How Can I Contribute?

### Reporting Bugs
#### Before Submitting A Bug Report
#### How Do I Submit A (Good) Bug Report?

### Suggesting Enhancements
#### Before Submitting An Enhancement Suggestion
#### How Do I Submit A (Good) Enhancement Suggestion?

### Your First Code Contribution
#### Local development

### Pull Requests
