"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _uniqueId2 = _interopRequireDefault(require("lodash/uniqueId"));

var _defaults2 = _interopRequireDefault(require("lodash/defaults"));

var _assign2 = _interopRequireDefault(require("lodash/assign"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _victoryCore = require("victory-core");

var _flyout = _interopRequireDefault(require("./flyout"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (typeof call === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var fallbackProps = {
  cornerRadius: 5,
  pointerLength: 10,
  pointerWidth: 10
};

var VictoryTooltip =
/*#__PURE__*/
function (_React$Component) {
  _inherits(VictoryTooltip, _React$Component);

  function VictoryTooltip(props) {
    var _this;

    _classCallCheck(this, VictoryTooltip);

    _this = _possibleConstructorReturn(this, (VictoryTooltip.__proto__ || Object.getPrototypeOf(VictoryTooltip)).call(this, props));
    _this.id = props.id === undefined ? (0, _uniqueId2.default)("tooltip-") : props.id;
    return _this;
  }

  _createClass(VictoryTooltip, [{
    key: "getDefaultOrientation",
    value: function getDefaultOrientation(props) {
      var datum = props.datum,
          horizontal = props.horizontal,
          polar = props.polar;

      if (!polar) {
        var positive = horizontal ? "right" : "top";
        var negative = horizontal ? "left" : "bottom";
        return datum && datum.y < 0 ? negative : positive;
      } else {
        return this.getPolarOrientation(props, datum);
      }
    }
  }, {
    key: "getPolarOrientation",
    value: function getPolarOrientation(props, datum) {
      var degrees = _victoryCore.LabelHelpers.getDegrees(props, datum);

      var placement = props.labelPlacement || "vertical";

      if (placement === " vertical") {
        return this.getVerticalOrientations(degrees);
      } else if (placement === "parallel") {
        return degrees < 90 || degrees > 270 ? "right" : "left";
      } else {
        return degrees > 180 ? "bottom" : "top";
      }
    }
  }, {
    key: "getVerticalOrientations",
    value: function getVerticalOrientations(degrees) {
      if (degrees < 45 || degrees > 315) {
        // eslint-disable-line no-magic-numbers
        return "right";
      } else if (degrees >= 45 && degrees <= 135) {
        // eslint-disable-line no-magic-numbers
        return "top";
      } else if (degrees > 135 && degrees < 225) {
        // eslint-disable-line no-magic-numbers
        return "left";
      } else {
        return "bottom";
      }
    }
  }, {
    key: "getEvaluatedProps",
    value: function getEvaluatedProps(props) {
      var horizontal = props.horizontal,
          datum = props.datum,
          pointerLength = props.pointerLength,
          pointerWidth = props.pointerWidth,
          cornerRadius = props.cornerRadius,
          width = props.width,
          height = props.height,
          dx = props.dx,
          dy = props.dy,
          text = props.text,
          active = props.active;
      var style = Array.isArray(props.style) ? props.style.map(function (s) {
        return _victoryCore.Helpers.evaluateStyle(s, datum, active);
      }) : _victoryCore.Helpers.evaluateStyle(props.style, datum, active);

      var flyoutStyle = _victoryCore.Helpers.evaluateStyle(props.flyoutStyle, datum, active);

      var padding = flyoutStyle && flyoutStyle.padding || 0;
      var defaultDx = horizontal ? padding : 0;
      var defaultDy = horizontal ? 0 : padding;
      var orientation = _victoryCore.Helpers.evaluateProp(props.orientation, datum, active) || this.getDefaultOrientation(props);
      return (0, _assign2.default)({}, props, {
        style: style,
        flyoutStyle: flyoutStyle,
        orientation: orientation,
        dx: dx !== undefined ? _victoryCore.Helpers.evaluateProp(dx, datum, active) : defaultDx,
        dy: dy !== undefined ? _victoryCore.Helpers.evaluateProp(dy, datum, active) : defaultDy,
        cornerRadius: _victoryCore.Helpers.evaluateProp(cornerRadius, datum, active),
        pointerLength: _victoryCore.Helpers.evaluateProp(pointerLength, datum, active),
        pointerWidth: _victoryCore.Helpers.evaluateProp(pointerWidth, datum, active),
        width: _victoryCore.Helpers.evaluateProp(width, datum, active),
        height: _victoryCore.Helpers.evaluateProp(height, datum, active),
        active: _victoryCore.Helpers.evaluateProp(active, datum, active),
        text: _victoryCore.Helpers.evaluateProp(text, datum, active)
      });
    }
  }, {
    key: "getCalculatedValues",
    value: function getCalculatedValues(props) {
      var style = props.style,
          text = props.text,
          datum = props.datum,
          active = props.active;
      var theme = props.theme || _victoryCore.VictoryTheme.grayscale;
      var defaultLabelStyles = theme && theme.tooltip && theme.tooltip.style ? theme.tooltip.style : {};
      var baseLabelStyle = Array.isArray(style) ? style.map(function (s) {
        return (0, _defaults2.default)({}, s, defaultLabelStyles);
      }) : (0, _defaults2.default)({}, style, defaultLabelStyles);
      var defaultFlyoutStyles = theme && theme.tooltip && theme.tooltip.flyoutStyle ? theme.tooltip.flyoutStyle : {};
      var flyoutStyle = props.flyoutStyle ? (0, _defaults2.default)({}, props.flyoutStyle, defaultFlyoutStyles) : defaultFlyoutStyles;
      var labelStyle = Array.isArray(baseLabelStyle) ? baseLabelStyle.map(function (s) {
        return _victoryCore.Helpers.evaluateStyle(s, datum, active);
      }) : _victoryCore.Helpers.evaluateStyle(baseLabelStyle, datum, active);

      var labelSize = _victoryCore.TextSize.approximateTextSize(text, labelStyle);

      var flyoutDimensions = this.getDimensions(props, labelSize, labelStyle);
      var flyoutCenter = this.getFlyoutCenter(props, flyoutDimensions);
      var transform = this.getTransform(props);
      return {
        labelStyle: labelStyle,
        flyoutStyle: flyoutStyle,
        labelSize: labelSize,
        flyoutDimensions: flyoutDimensions,
        flyoutCenter: flyoutCenter,
        transform: transform
      };
    }
  }, {
    key: "getTransform",
    value: function getTransform(props) {
      var x = props.x,
          y = props.y,
          style = props.style;
      var labelStyle = style || {};
      var angle = labelStyle.angle || props.angle || this.getDefaultAngle(props);
      return angle ? "rotate(".concat(angle, " ").concat(x, " ").concat(y, ")") : undefined;
    } // eslint-disable-next-line complexity

  }, {
    key: "getDefaultAngle",
    value: function getDefaultAngle(props) {
      var polar = props.polar,
          labelPlacement = props.labelPlacement,
          orientation = props.orientation,
          datum = props.datum;

      if (!polar || !labelPlacement || labelPlacement === "vertical") {
        return 0;
      }

      var degrees = _victoryCore.LabelHelpers.getDegrees(props, datum);

      var sign = degrees > 90 && degrees < 180 || degrees > 270 ? 1 : -1;
      var labelRotation = labelPlacement === "perpendicular" ? 0 : 90;
      var angle;

      if (degrees === 0 || degrees === 180) {
        angle = orientation === "top" && degrees === 180 ? 270 : 90;
      } else if (degrees > 0 && degrees < 180) {
        angle = 90 - degrees;
      } else if (degrees > 180 && degrees < 360) {
        angle = 270 - degrees;
      }

      return angle + sign * labelRotation;
    }
  }, {
    key: "getFlyoutCenter",
    value: function getFlyoutCenter(props, dimensions) {
      var x = props.x,
          y = props.y,
          dx = props.dx,
          dy = props.dy,
          pointerLength = props.pointerLength,
          orientation = props.orientation;
      var height = dimensions.height,
          width = dimensions.width;
      var xSign = orientation === "left" ? -1 : 1;
      var ySign = orientation === "bottom" ? -1 : 1;
      return {
        x: orientation === "left" || orientation === "right" ? x + xSign * (pointerLength + width / 2 + dx) : x + dx,
        y: orientation === "top" || orientation === "bottom" ? y - ySign * (pointerLength + height / 2 + dy) : y - dy
      };
    }
  }, {
    key: "getLabelPadding",
    value: function getLabelPadding(style) {
      if (!style) {
        return 0;
      }

      var paddings = Array.isArray(style) ? style.map(function (s) {
        return s.padding;
      }) : [style.padding];
      return Math.max.apply(Math, _toConsumableArray(paddings).concat([0]));
    }
  }, {
    key: "getDimensions",
    value: function getDimensions(props, labelSize, labelStyle) {
      var orientation = props.orientation,
          cornerRadius = props.cornerRadius,
          pointerLength = props.pointerLength,
          pointerWidth = props.pointerWidth;
      var padding = this.getLabelPadding(labelStyle);

      var getHeight = function () {
        var calculatedHeight = labelSize.height + padding;
        var minHeight = orientation === "top" || orientation === "bottom" ? 2 * cornerRadius : 2 * cornerRadius + pointerWidth;
        return Math.max(minHeight, calculatedHeight);
      };

      var getWidth = function () {
        var calculatedWidth = labelSize.width + padding;
        var minWidth = orientation === "left" || orientation === "right" ? 2 * cornerRadius + pointerLength : 2 * cornerRadius;
        return Math.max(minWidth, calculatedWidth);
      };

      return {
        height: props.height || getHeight(props, labelSize, orientation) + padding / 2,
        width: props.width || getWidth(props, labelSize, orientation) + padding
      };
    }
  }, {
    key: "getLabelProps",
    value: function getLabelProps(props, calculatedValues) {
      var flyoutCenter = calculatedValues.flyoutCenter,
          labelStyle = calculatedValues.labelStyle,
          labelSize = calculatedValues.labelSize,
          dy = calculatedValues.dy,
          dx = calculatedValues.dx;
      var text = props.text,
          datum = props.datum,
          labelComponent = props.labelComponent,
          index = props.index;
      var textAnchor = (Array.isArray(labelStyle) && labelStyle.length ? labelStyle[0].textAnchor : labelStyle.textAnchor) || "middle";

      var getLabelX = function () {
        var sign = textAnchor === "end" ? -1 : 1;
        return flyoutCenter.x - sign * (labelSize.width / 2);
      };

      return (0, _defaults2.default)({}, labelComponent.props, {
        key: "".concat(this.id, "-label-").concat(index),
        text: text,
        datum: datum,
        textAnchor: textAnchor,
        dy: dy,
        dx: dx,
        style: labelStyle,
        x: !textAnchor || textAnchor === "middle" ? flyoutCenter.x : getLabelX(),
        y: flyoutCenter.y,
        verticalAnchor: "middle",
        angle: labelStyle.angle
      });
    }
  }, {
    key: "getFlyoutProps",
    value: function getFlyoutProps(props, calculatedValues) {
      var flyoutDimensions = calculatedValues.flyoutDimensions,
          flyoutStyle = calculatedValues.flyoutStyle;
      var x = props.x,
          y = props.y,
          dx = props.dx,
          dy = props.dy,
          datum = props.datum,
          index = props.index,
          orientation = props.orientation,
          pointerLength = props.pointerLength,
          pointerWidth = props.pointerWidth,
          cornerRadius = props.cornerRadius,
          events = props.events,
          flyoutComponent = props.flyoutComponent;
      return (0, _defaults2.default)({}, flyoutComponent.props, {
        x: x,
        y: y,
        dx: dx,
        dy: dy,
        datum: datum,
        index: index,
        orientation: orientation,
        pointerLength: pointerLength,
        pointerWidth: pointerWidth,
        cornerRadius: cornerRadius,
        events: events,
        key: "".concat(this.id, "-tooltip-").concat(index),
        width: flyoutDimensions.width,
        height: flyoutDimensions.height,
        style: flyoutStyle
      });
    } // Overridden in victory-core-native

  }, {
    key: "renderTooltip",
    value: function renderTooltip(props) {
      var evaluatedProps = this.getEvaluatedProps(props);
      var flyoutComponent = evaluatedProps.flyoutComponent,
          labelComponent = evaluatedProps.labelComponent,
          groupComponent = evaluatedProps.groupComponent,
          active = evaluatedProps.active,
          renderInPortal = evaluatedProps.renderInPortal;

      if (!active) {
        return renderInPortal ? _react.default.createElement(_victoryCore.VictoryPortal, null, null) : null;
      }

      var calculatedValues = this.getCalculatedValues(evaluatedProps);
      var children = [_react.default.cloneElement(flyoutComponent, this.getFlyoutProps(evaluatedProps, calculatedValues)), _react.default.cloneElement(labelComponent, this.getLabelProps(evaluatedProps, calculatedValues))];

      var tooltip = _react.default.cloneElement(groupComponent, {
        role: "presentation",
        transform: calculatedValues.transform
      }, children);

      return renderInPortal ? _react.default.createElement(_victoryCore.VictoryPortal, null, tooltip) : tooltip;
    }
  }, {
    key: "render",
    value: function render() {
      var props = _victoryCore.Helpers.modifyProps(this.props, fallbackProps, "tooltip");

      return this.renderTooltip(props);
    }
  }]);

  return VictoryTooltip;
}(_react.default.Component);

exports.default = VictoryTooltip;
Object.defineProperty(VictoryTooltip, "displayName", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: "VictoryTooltip"
});
Object.defineProperty(VictoryTooltip, "propTypes", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    activateData: _propTypes.default.bool,
    active: _propTypes.default.oneOfType([_propTypes.default.bool, _propTypes.default.func]),
    angle: _propTypes.default.number,
    cornerRadius: _propTypes.default.oneOfType([_victoryCore.PropTypes.nonNegative, _propTypes.default.func]),
    data: _propTypes.default.array,
    datum: _propTypes.default.object,
    dx: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.func]),
    dy: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.func]),
    events: _propTypes.default.object,
    flyoutComponent: _propTypes.default.element,
    flyoutStyle: _propTypes.default.object,
    groupComponent: _propTypes.default.element,
    height: _propTypes.default.oneOfType([_victoryCore.PropTypes.nonNegative, _propTypes.default.func]),
    horizontal: _propTypes.default.bool,
    id: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
    index: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
    labelComponent: _propTypes.default.element,
    orientation: _propTypes.default.oneOfType([_propTypes.default.oneOf(["top", "bottom", "left", "right"]), _propTypes.default.func]),
    pointerLength: _propTypes.default.oneOfType([_victoryCore.PropTypes.nonNegative, _propTypes.default.func]),
    pointerWidth: _propTypes.default.oneOfType([_victoryCore.PropTypes.nonNegative, _propTypes.default.func]),
    polar: _propTypes.default.bool,
    renderInPortal: _propTypes.default.bool,
    style: _propTypes.default.oneOfType([_propTypes.default.object, _propTypes.default.array]),
    text: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number, _propTypes.default.func, _propTypes.default.array]),
    theme: _propTypes.default.object,
    width: _propTypes.default.oneOfType([_victoryCore.PropTypes.nonNegative, _propTypes.default.func]),
    x: _propTypes.default.number,
    y: _propTypes.default.number
  }
});
Object.defineProperty(VictoryTooltip, "defaultProps", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    active: false,
    renderInPortal: true,
    labelComponent: _react.default.createElement(_victoryCore.VictoryLabel, null),
    flyoutComponent: _react.default.createElement(_flyout.default, null),
    groupComponent: _react.default.createElement("g", null)
  }
});
Object.defineProperty(VictoryTooltip, "defaultEvents", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: function (props) {
    return [{
      target: "data",
      eventHandlers: {
        onMouseOver: function () {
          return props.activateData ? [{
            target: "labels",
            mutation: function () {
              return {
                active: true
              };
            }
          }, {
            target: "data",
            mutation: function () {
              return {
                active: true
              };
            }
          }] : [{
            target: "labels",
            mutation: function () {
              return {
                active: true
              };
            }
          }];
        },
        onTouchStart: function () {
          return props.activateData ? [{
            target: "labels",
            mutation: function () {
              return {
                active: true
              };
            }
          }, {
            target: "data",
            mutation: function () {
              return {
                active: true
              };
            }
          }] : [{
            target: "labels",
            mutation: function () {
              return {
                active: true
              };
            }
          }];
        },
        onMouseOut: function () {
          return props.activateData ? [{
            target: "labels",
            mutation: function () {
              return {
                active: undefined
              };
            }
          }, {
            target: "data",
            mutation: function () {
              return {
                active: undefined
              };
            }
          }] : [{
            target: "labels",
            mutation: function () {
              return {
                active: undefined
              };
            }
          }];
        },
        onTouchEnd: function () {
          return props.activateData ? [{
            target: "labels",
            mutation: function () {
              return {
                active: undefined
              };
            }
          }, {
            target: "data",
            mutation: function () {
              return {
                active: undefined
              };
            }
          }] : [{
            target: "labels",
            mutation: function () {
              return {
                active: undefined
              };
            }
          }];
        }
      }
    }];
  }
});