"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBaseProps = void 0;

var _assign2 = _interopRequireDefault(require("lodash/assign"));

var _victoryCore = require("victory-core");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var getCalculatedValues = function (props) {
  var data = _victoryCore.Data.getData(props);

  if (data.length < 2) {
    data = [];
  }

  var range = {
    x: _victoryCore.Helpers.getRange(props, "x"),
    y: _victoryCore.Helpers.getRange(props, "y")
  };
  var domain = {
    x: _victoryCore.Domain.getDomain(props, "x"),
    y: _victoryCore.Domain.getDomain(props, "y")
  };
  var scale = {
    x: _victoryCore.Scale.getBaseScale(props, "x").domain(domain.x).range(range.x),
    y: _victoryCore.Scale.getBaseScale(props, "y").domain(domain.y).range(range.y)
  };
  var origin = props.polar ? props.origin || _victoryCore.Helpers.getPolarOrigin(props) : undefined;
  var defaultStyles = props.theme && props.theme.line && props.theme.line.style ? props.theme.line.style : {};

  var style = _victoryCore.Helpers.getStyles(props.style, defaultStyles);

  return {
    domain: domain,
    data: data,
    scale: scale,
    style: style,
    origin: origin
  };
};

var getBaseProps = function (props, fallbackProps) {
  var modifiedProps = _victoryCore.Helpers.modifyProps(props, fallbackProps, "line");

  props = (0, _assign2.default)({}, modifiedProps, getCalculatedValues(modifiedProps));
  var _props = props,
      data = _props.data,
      domain = _props.domain,
      events = _props.events,
      groupComponent = _props.groupComponent,
      height = _props.height,
      interpolation = _props.interpolation,
      origin = _props.origin,
      padding = _props.padding,
      polar = _props.polar,
      scale = _props.scale,
      sharedEvents = _props.sharedEvents,
      standalone = _props.standalone,
      style = _props.style,
      theme = _props.theme,
      width = _props.width,
      labels = _props.labels,
      name = _props.name;
  var initialChildProps = {
    parent: {
      style: style.parent,
      scale: scale,
      data: data,
      height: height,
      width: width,
      name: name,
      domain: domain,
      standalone: standalone,
      polar: polar,
      origin: origin,
      padding: padding
    },
    all: {
      data: {
        polar: polar,
        origin: origin,
        scale: scale,
        data: data,
        interpolation: interpolation,
        groupComponent: groupComponent,
        theme: theme,
        style: style.data
      }
    }
  };
  return data.reduce(function (childProps, datum, index) {
    var text = _victoryCore.LabelHelpers.getText(props, datum, index);

    if (text !== undefined && text !== null || labels && (events || sharedEvents)) {
      var eventKey = datum.eventKey || index;
      childProps[eventKey] = {
        labels: _victoryCore.LabelHelpers.getProps(props, index)
      };
    }

    return childProps;
  }, initialChildProps);
};

exports.getBaseProps = getBaseProps;