"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _uniqueId2 = _interopRequireDefault(require("lodash/uniqueId"));

var _isEmpty2 = _interopRequireDefault(require("lodash/isEmpty"));

var _defaults2 = _interopRequireDefault(require("lodash/defaults"));

var _assign2 = _interopRequireDefault(require("lodash/assign"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _victoryPortal = _interopRequireDefault(require("../victory-portal/victory-portal"));

var _propTypes2 = _interopRequireDefault(require("../victory-util/prop-types"));

var _helpers = _interopRequireDefault(require("../victory-util/helpers"));

var _labelHelpers = _interopRequireDefault(require("../victory-util/label-helpers"));

var _style = _interopRequireDefault(require("../victory-util/style"));

var _log = _interopRequireDefault(require("../victory-util/log"));

var _tspan = _interopRequireDefault(require("../victory-primitives/tspan"));

var _text = _interopRequireDefault(require("../victory-primitives/text"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (typeof call === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var defaultStyles = {
  fill: "#252525",
  fontSize: 14,
  fontFamily: "'Gill Sans', 'Gill Sans MT', 'Ser­avek', 'Trebuchet MS', sans-serif",
  stroke: "transparent"
};

var VictoryLabel =
/*#__PURE__*/
function (_React$Component) {
  _inherits(VictoryLabel, _React$Component);

  function VictoryLabel(props) {
    var _this;

    _classCallCheck(this, VictoryLabel);

    _this = _possibleConstructorReturn(this, (VictoryLabel.__proto__ || Object.getPrototypeOf(VictoryLabel)).call(this, props));
    _this.id = props.id === undefined ? (0, _uniqueId2.default)("label-") : props.id;
    return _this;
  }

  _createClass(VictoryLabel, [{
    key: "getPosition",
    value: function getPosition(props, dimension) {
      if (!props.datum) {
        return 0;
      }

      var scaledPoint = _helpers.default.scalePoint(props, props.datum);

      return scaledPoint[dimension];
    }
  }, {
    key: "getStyle",
    value: function getStyle(props, style) {
      style = style ? (0, _defaults2.default)({}, style, defaultStyles) : defaultStyles;
      var datum = props.datum || props.data;

      var baseStyles = _helpers.default.evaluateStyle(style, datum, props.active);

      return (0, _assign2.default)({}, baseStyles, {
        fontSize: this.getFontSize(baseStyles)
      });
    }
  }, {
    key: "getStyles",
    value: function getStyles(props) {
      var _this2 = this;

      return Array.isArray(props.style) && !(0, _isEmpty2.default)(props.style) ? props.style.map(function (style) {
        return _this2.getStyle(props, style);
      }) : [this.getStyle(props, props.style)];
    }
  }, {
    key: "getHeight",
    value: function getHeight(props, type) {
      var datum = props.datum || props.data;
      return _helpers.default.evaluateProp(props[type], datum, props.active);
    }
  }, {
    key: "getContent",
    value: function getContent(props) {
      if (props.text === undefined || props.text === null) {
        return undefined;
      }

      var datum = props.datum || props.data;

      if (Array.isArray(props.text)) {
        return props.text.map(function (line) {
          return _helpers.default.evaluateProp(line, datum, props.active);
        });
      }

      var child = _helpers.default.evaluateProp(props.text, datum, props.active);

      if (child === undefined || child === null) {
        return undefined;
      }

      return "".concat(child).split("\n");
    }
  }, {
    key: "getDy",
    value: function getDy(props, style, content, lineHeight) {
      //eslint-disable-line max-params
      style = Array.isArray(style) ? style[0] : style;
      lineHeight = this.checkLineHeight(lineHeight, lineHeight[0], 1);
      var fontSize = style.fontSize;
      var datum = props.datum || props.data;
      var dy = props.dy ? _helpers.default.evaluateProp(props.dy, datum, props.active) : 0;
      var length = content.length;
      var capHeight = this.getHeight(props, "capHeight");
      var verticalAnchor = style.verticalAnchor || props.verticalAnchor;
      var anchor = verticalAnchor ? _helpers.default.evaluateProp(verticalAnchor, datum) : "middle";

      switch (anchor) {
        case "end":
          return dy + (capHeight / 2 + (0.5 - length) * lineHeight) * fontSize;

        case "middle":
          return dy + (capHeight / 2 + (0.5 - length / 2) * lineHeight) * fontSize;

        default:
          return dy + (capHeight / 2 + lineHeight / 2) * fontSize;
      }
    }
  }, {
    key: "checkLineHeight",
    value: function checkLineHeight(lineHeight, val, fallbackVal) {
      if (Array.isArray(lineHeight)) {
        return (0, _isEmpty2.default)(lineHeight) ? fallbackVal : val;
      }

      return lineHeight;
    }
  }, {
    key: "getTransform",
    value: function getTransform(props, style) {
      var active = props.active,
          datum = props.datum,
          x = props.x,
          y = props.y,
          polar = props.polar;
      var defaultAngle = polar ? _labelHelpers.default.getPolarAngle(props) : 0;
      var baseAngle = style.angle === undefined ? props.angle : style.angle;
      var angle = baseAngle === undefined ? defaultAngle : baseAngle;
      var transform = props.transform || style.transform;

      var transformPart = transform && _helpers.default.evaluateProp(transform, datum, active);

      var rotatePart = angle && {
        rotate: [angle, x, y]
      };
      return transformPart || angle ? _style.default.toTransformString(transformPart, rotatePart) : undefined;
    }
  }, {
    key: "getFontSize",
    value: function getFontSize(style) {
      var baseSize = style && style.fontSize;

      if (typeof baseSize === "number") {
        return baseSize;
      } else if (baseSize === undefined || baseSize === null) {
        return defaultStyles.fontSize;
      } else if (typeof baseSize === "string") {
        var fontSize = +baseSize.replace("px", "");

        if (!isNaN(fontSize)) {
          return fontSize;
        } else {
          _log.default.warn("fontSize should be expressed as a number of pixels");

          return defaultStyles.fontSize;
        }
      }

      return defaultStyles.fontSize;
    }
  }, {
    key: "renderElements",
    value: function renderElements(props, content) {
      var _this3 = this;

      var datum = props.datum,
          active = props.active,
          inline = props.inline,
          className = props.className,
          title = props.title,
          desc = props.desc,
          events = props.events,
          direction = props.direction;
      var style = this.getStyles(props);
      var lineHeight = this.getHeight(props, "lineHeight");
      var textAnchor = props.textAnchor ? _helpers.default.evaluateProp(props.textAnchor, datum, active) : "start";
      var dx = props.dx ? _helpers.default.evaluateProp(props.dx, datum, active) : 0;
      var dy = this.getDy(props, style, content, lineHeight);
      var transform = this.getTransform(props, style);
      var x = props.x !== undefined ? props.x : this.getPosition(props, "x");
      var y = props.y !== undefined ? props.y : this.getPosition(props, "y");
      var textChildren = content.map(function (line, i) {
        var currentStyle = style[i] || style[0];
        var lastStyle = style[i - 1] || style[0];
        var fontSize = (currentStyle.fontSize + lastStyle.fontSize) / 2;

        var currentLineHeight = _this3.checkLineHeight(lineHeight, (lineHeight[i] + (lineHeight[i - 1] || lineHeight[0])) / 2, 1);

        var tspanProps = {
          key: "".concat(_this3.id, "-key-").concat(i),
          x: !inline ? props.x : undefined,
          dx: dx,
          dy: i && !inline ? currentLineHeight * fontSize : undefined,
          textAnchor: currentStyle.textAnchor || textAnchor,
          style: currentStyle,
          content: line
        };
        return _react.default.cloneElement(props.tspanComponent, tspanProps);
      });
      return _react.default.cloneElement(props.textComponent, {
        direction: direction,
        dx: dx,
        dy: dy,
        x: x,
        y: y,
        events: events,
        transform: transform,
        className: className,
        title: title,
        desc: desc,
        id: this.id
      }, textChildren);
    }
  }, {
    key: "render",
    value: function render() {
      var content = this.getContent(this.props);

      if (content === null || content === undefined) {
        return null;
      }

      var label = this.renderElements(this.props, content);
      return this.props.renderInPortal ? _react.default.createElement(_victoryPortal.default, null, label) : label;
    }
  }]);

  return VictoryLabel;
}(_react.default.Component);

exports.default = VictoryLabel;
Object.defineProperty(VictoryLabel, "displayName", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: "VictoryLabel"
});
Object.defineProperty(VictoryLabel, "role", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: "label"
});
Object.defineProperty(VictoryLabel, "propTypes", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    active: _propTypes.default.bool,
    angle: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),
    capHeight: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes2.default.nonNegative, _propTypes.default.func]),
    className: _propTypes.default.string,
    data: _propTypes.default.array,
    datum: _propTypes.default.any,
    desc: _propTypes.default.string,
    direction: _propTypes.default.oneOf(["rtl", "ltr", "inherit"]),
    dx: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string, _propTypes.default.func]),
    dy: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string, _propTypes.default.func]),
    events: _propTypes.default.object,
    id: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
    index: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
    inline: _propTypes.default.bool,
    labelPlacement: _propTypes.default.oneOf(["parallel", "perpendicular", "vertical"]),
    lineHeight: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes2.default.nonNegative, _propTypes.default.func, _propTypes.default.array]),
    origin: _propTypes.default.shape({
      x: _propTypes2.default.nonNegative,
      y: _propTypes2.default.nonNegative
    }),
    polar: _propTypes.default.bool,
    renderInPortal: _propTypes.default.bool,
    scale: _propTypes.default.shape({
      x: _propTypes2.default.scale,
      y: _propTypes2.default.scale
    }),
    style: _propTypes.default.oneOfType([_propTypes.default.object, _propTypes.default.array]),
    text: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number, _propTypes.default.func, _propTypes.default.array]),
    textAnchor: _propTypes.default.oneOfType([_propTypes.default.oneOf(["start", "middle", "end", "inherit"]), _propTypes.default.func]),
    textComponent: _propTypes.default.element,
    title: _propTypes.default.string,
    transform: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.object, _propTypes.default.func]),
    tspanComponent: _propTypes.default.element,
    verticalAnchor: _propTypes.default.oneOfType([_propTypes.default.oneOf(["start", "middle", "end"]), _propTypes.default.func]),
    x: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
    y: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string])
  }
});
Object.defineProperty(VictoryLabel, "defaultProps", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    direction: "inherit",
    textComponent: _react.default.createElement(_text.default, null),
    tspanComponent: _react.default.createElement(_tspan.default, null),
    capHeight: 0.71,
    // Magic number from d3.
    lineHeight: 1
  }
});