"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getChildren = getChildren;
exports.getCalculatedProps = getCalculatedProps;
exports.getChildComponents = void 0;

var _assign2 = _interopRequireDefault(require("lodash/assign"));

var _defaults2 = _interopRequireDefault(require("lodash/defaults"));

var _react = _interopRequireDefault(require("react"));

var _victoryCore = require("victory-core");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* eslint-disable func-style */

/* eslint-disable no-use-before-define */
function getAxisProps(child, props, calculatedProps) {
  var domain = calculatedProps.domain,
      scale = calculatedProps.scale,
      originSign = calculatedProps.originSign,
      stringMap = calculatedProps.stringMap,
      categories = calculatedProps.categories,
      horizontal = calculatedProps.horizontal;
  var childProps = child.props || {};
  var axis = child.type.getAxis(childProps);

  var currentAxis = _victoryCore.Axis.getCurrentAxis(axis, horizontal);

  var otherAxis = axis === "x" ? "y" : "x";
  var axisOffset = getAxisOffset(props, calculatedProps);
  var offsetY = axis === "y" ? undefined : axisOffset.y;
  var offsetX = axis === "x" ? undefined : axisOffset.x;
  var crossAxis = childProps.crossAxis === false ? false : true;

  var orientation = _victoryCore.Axis.getOrientation(child, axis, originSign[otherAxis]);

  return {
    stringMap: stringMap[currentAxis],
    categories: categories[currentAxis],
    startAngle: props.startAngle,
    endAngle: props.endAngle,
    innerRadius: props.innerRadius,
    domain: domain,
    scale: scale,
    offsetY: childProps.offsetY !== undefined ? childProps.offsetY : offsetY,
    offsetX: childProps.offsetX !== undefined ? childProps.offsetX : offsetX,
    crossAxis: crossAxis,
    orientation: orientation
  };
}

function getChildProps(child, props, calculatedProps) {
  var axisChild = _victoryCore.Axis.findAxisComponents([child]);

  if (axisChild.length > 0) {
    return getAxisProps(axisChild[0], props, calculatedProps);
  }

  var categories = calculatedProps.categories,
      domain = calculatedProps.domain,
      range = calculatedProps.range,
      scale = calculatedProps.scale;
  return {
    categories: categories,
    domain: domain,
    range: range,
    scale: scale
  };
}

function getStyles(props) {
  var styleProps = props.style && props.style.parent;
  return {
    parent: (0, _defaults2.default)({}, styleProps, {
      height: "100%",
      width: "100%",
      userSelect: "none"
    })
  };
}

function getCalculatedProps(props, childComponents) {
  var style = getStyles(props);

  var horizontal = _victoryCore.Helpers.isHorizontal(props); // TODO: check


  var categories = {
    x: _victoryCore.Wrapper.getCategories(props, "x", childComponents),
    y: _victoryCore.Wrapper.getCategories(props, "y", childComponents)
  };
  var stringMap = {
    x: createStringMap(props, "x", childComponents),
    y: createStringMap(props, "y", childComponents)
  };
  var axisComponents = {
    x: _victoryCore.Axis.getAxisComponent(childComponents, "x"),
    y: _victoryCore.Axis.getAxisComponent(childComponents, "y")
  };
  var domain = {
    x: getDomain((0, _assign2.default)({}, props, {
      categories: categories
    }), "x", childComponents),
    y: getDomain((0, _assign2.default)({}, props, {
      categories: categories
    }), "y", childComponents)
  };
  var range = {
    x: _victoryCore.Helpers.getRange(props, "x"),
    y: _victoryCore.Helpers.getRange(props, "y")
  };
  var baseScale = {
    x: _victoryCore.Scale.getScaleFromProps(props, "x") || axisComponents.x && axisComponents.x.type.getScale(axisComponents.x.props) || _victoryCore.Scale.getDefaultScale(),
    y: _victoryCore.Scale.getScaleFromProps(props, "y") || axisComponents.y && axisComponents.y.type.getScale(axisComponents.y.props) || _victoryCore.Scale.getDefaultScale()
  };
  var scale = {
    x: baseScale.x.domain(domain.x).range(range.x),
    y: baseScale.y.domain(domain.y).range(range.y)
  };
  var origin = props.polar ? _victoryCore.Helpers.getPolarOrigin(props) : _victoryCore.Axis.getOrigin(domain);
  var originSign = {
    x: _victoryCore.Axis.getOriginSign(origin.x, domain.x),
    y: _victoryCore.Axis.getOriginSign(origin.y, domain.y)
  };
  var defaultDomainPadding = getDefaultDomainPadding(childComponents, horizontal);

  var padding = _victoryCore.Helpers.getPadding(props);

  return {
    axisComponents: axisComponents,
    categories: categories,
    domain: domain,
    range: range,
    horizontal: horizontal,
    scale: scale,
    stringMap: stringMap,
    style: style,
    origin: origin,
    originSign: originSign,
    defaultDomainPadding: defaultDomainPadding,
    padding: padding
  };
}

function getChildren(props, childComponents, calculatedProps) {
  childComponents = childComponents || getChildComponents(props);
  calculatedProps = calculatedProps || getCalculatedProps(props, childComponents);
  var baseStyle = calculatedProps.style.parent;
  var height = props.height,
      polar = props.polar,
      theme = props.theme,
      width = props.width;
  var _calculatedProps = calculatedProps,
      origin = _calculatedProps.origin,
      horizontal = _calculatedProps.horizontal;
  var parentName = props.name || "chart";
  return childComponents.map(function (child, index) {
    var role = child.type && child.type.role;
    var style = Array.isArray(child.props.style) ? child.props.style : (0, _defaults2.default)({}, child.props.style, {
      parent: baseStyle
    });
    var childProps = getChildProps(child, props, calculatedProps);
    var name = child.props.name || "".concat(parentName, "-").concat(role, "-").concat(index);
    var newProps = (0, _defaults2.default)({
      horizontal: horizontal,
      height: height,
      polar: polar,
      theme: theme,
      width: width,
      style: style,
      name: name,
      origin: polar ? origin : undefined,
      padding: calculatedProps.padding,
      key: "".concat(name, "-key-").concat(index),
      standalone: false
    }, childProps);
    return _react.default.cloneElement(child, newProps);
  });
}

var getChildComponents = function (props, defaultAxes) {
  var childComponents = _react.default.Children.toArray(props.children);

  if (childComponents.length === 0) {
    return [defaultAxes.independent, defaultAxes.dependent];
  }

  var axisComponents = {
    dependent: _victoryCore.Axis.getAxisComponentsWithParent(childComponents, "dependent"),
    independent: _victoryCore.Axis.getAxisComponentsWithParent(childComponents, "independent")
  };

  if (axisComponents.dependent.length === 0 && axisComponents.independent.length === 0) {
    return childComponents.concat([defaultAxes.independent, defaultAxes.dependent]);
  }

  var axisCount = 0;
  return childComponents.filter(function (child) {
    var role = child.type && child.type.role;
    var childProps = child.props || {};

    if (role !== "axis" || childProps.dependentAxis) {
      return true;
    } else if (axisCount < 1) {
      axisCount++;
      return true;
    } else {
      var msg = "Only one independent VictoryAxis component is allowed when " + "using the VictoryChart wrapper. Only the first axis will be used. Please compose " + "multi-axis charts manually";

      _victoryCore.Log.warn(msg);

      return false;
    }
  });
};

exports.getChildComponents = getChildComponents;

var getDefaultDomainPadding = function (childComponents, horizontal) {
  var groupComponent = childComponents.filter(function (child) {
    return child.type && child.type.role && child.type.role === "group";
  });

  if (groupComponent.length < 1) {
    return undefined;
  }

  var _groupComponent$0$pro = groupComponent[0].props,
      offset = _groupComponent$0$pro.offset,
      children = _groupComponent$0$pro.children;
  return horizontal ? {
    y: offset * children.length / 2
  } : {
    x: offset * children.length / 2
  };
};

var getDomain = function (props, axis, childComponents) {
  childComponents = childComponents || _react.default.Children.toArray(props.children);

  var domain = _victoryCore.Wrapper.getDomain(props, axis, childComponents);

  var axisComponent = _victoryCore.Axis.getAxisComponent(childComponents, axis);

  var invertDomain = axisComponent && axisComponent.props && axisComponent.props.invertAxis;
  return invertDomain ? domain.concat().reverse() : domain;
}; // eslint-disable-next-line complexity


var getAxisOffset = function (props, calculatedProps) {
  var axisComponents = calculatedProps.axisComponents,
      scale = calculatedProps.scale,
      origin = calculatedProps.origin,
      domain = calculatedProps.domain,
      originSign = calculatedProps.originSign,
      padding = calculatedProps.padding;
  var top = padding.top,
      bottom = padding.bottom,
      left = padding.left,
      right = padding.right; // make the axes line up, and cross when appropriate

  var axisOrientations = {
    x: _victoryCore.Axis.getOrientation(axisComponents.x, "x", originSign.y),
    y: _victoryCore.Axis.getOrientation(axisComponents.y, "y", originSign.x)
  };
  var orientationOffset = {
    y: axisOrientations.x === "bottom" ? bottom : top,
    x: axisOrientations.y === "left" ? left : right
  };
  var originOffset = {
    x: axisOrientations.y === "left" ? 0 : props.width,
    y: axisOrientations.x === "bottom" ? props.height : 0
  };
  var originPosition = {
    x: origin.x === domain.x[0] || origin.x === domain.x[1] ? 0 : scale.x(origin.x),
    y: origin.y === domain.y[0] || origin.y === domain.y[1] ? 0 : scale.y(origin.y)
  };
  var calculatedOffset = {
    x: originPosition.x ? Math.abs(originOffset.x - originPosition.x) : orientationOffset.x,
    y: originPosition.y ? Math.abs(originOffset.y - originPosition.y) : orientationOffset.y
  };
  return {
    x: axisComponents.x && axisComponents.x.offsetX !== undefined ? axisComponents.x.offsetX : calculatedOffset.x,
    y: axisComponents.y && axisComponents.y.offsetY !== undefined ? axisComponents.y.offsetY : calculatedOffset.y
  };
};

var createStringMap = function (props, axis, childComponents) {
  var allStrings = _victoryCore.Wrapper.getStringsFromChildren(props, axis, childComponents);

  return allStrings.length === 0 ? null : allStrings.reduce(function (memo, string, index) {
    memo[string] = index + 1;
    return memo;
  }, {});
};