"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _assign2 = _interopRequireDefault(require("lodash/assign"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var d3Shape = _interopRequireWildcard(require("d3-shape"));

var _victoryCore = require("victory-core");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (typeof call === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var defined = function (d) {
  var y = d._y1 !== undefined ? d._y1 : d._y;
  return y !== null && y !== undefined && d._y0 !== null;
};

var getXAccessor = function (scale) {
  return function (d) {
    return scale.x(d._x1 !== undefined ? d._x1 : d._x);
  };
};

var getYAccessor = function (scale) {
  return function (d) {
    return scale.y(d._y1 !== undefined ? d._y1 : d._y);
  };
};

var getY0Accessor = function (scale) {
  return function (d) {
    return scale.y(d._y0);
  };
};

var getAngleAccessor = function (scale) {
  return function (d) {
    var x = scale.x(d._x1 !== undefined ? d._x1 : d._x);
    return -1 * x + Math.PI / 2;
  };
};

var Area =
/*#__PURE__*/
function (_React$Component) {
  _inherits(Area, _React$Component);

  function Area() {
    _classCallCheck(this, Area);

    return _possibleConstructorReturn(this, (Area.__proto__ || Object.getPrototypeOf(Area)).apply(this, arguments));
  }

  _createClass(Area, [{
    key: "getLineFunction",
    value: function getLineFunction(props) {
      var polar = props.polar,
          scale = props.scale;
      var interpolation = this.toNewName(props.interpolation);
      return polar ? d3Shape.lineRadial().defined(defined).curve(d3Shape["".concat(interpolation, "Closed")]).angle(getAngleAccessor(scale)).radius(getY0Accessor(scale)) : d3Shape.line().defined(defined).curve(d3Shape[interpolation]).x(getXAccessor(scale)).y(getYAccessor(scale));
    }
  }, {
    key: "getAreaFunction",
    value: function getAreaFunction(props) {
      var polar = props.polar,
          scale = props.scale;
      var interpolation = this.toNewName(props.interpolation);
      return polar ? d3Shape.radialArea().defined(defined).curve(d3Shape["".concat(interpolation, "Closed")]).angle(getAngleAccessor(scale)).outerRadius(getYAccessor(scale)).innerRadius(getY0Accessor(scale)) : d3Shape.area().defined(defined).curve(d3Shape[interpolation]).x(getXAccessor(scale)).y1(getYAccessor(scale)).y0(getY0Accessor(scale));
    }
  }, {
    key: "toNewName",
    value: function toNewName(interpolation) {
      // d3 shape changed the naming scheme for interpolators from "basis" -> "curveBasis" etc.
      var capitalize = function (s) {
        return s && s[0].toUpperCase() + s.slice(1);
      };

      return "curve".concat(capitalize(interpolation));
    }
  }, {
    key: "render",
    value: function render() {
      var _props = this.props,
          role = _props.role,
          shapeRendering = _props.shapeRendering,
          className = _props.className,
          polar = _props.polar,
          origin = _props.origin,
          data = _props.data,
          active = _props.active,
          pathComponent = _props.pathComponent,
          events = _props.events,
          groupComponent = _props.groupComponent,
          clipPath = _props.clipPath,
          id = _props.id;

      var style = _victoryCore.Helpers.evaluateStyle((0, _assign2.default)({
        fill: "black"
      }, this.props.style), data, active);

      var defaultTransform = polar && origin ? "translate(".concat(origin.x, ", ").concat(origin.y, ")") : undefined;
      var transform = this.props.transform || defaultTransform;
      var renderLine = style.stroke && style.stroke !== "none" && style.stroke !== "transparent";
      var areaFunction = this.getAreaFunction(this.props);
      var lineFunction = renderLine && this.getLineFunction(this.props);
      var areaStroke = style.stroke ? "none" : style.fill;
      var sharedProps = {
        className: className,
        role: role,
        shapeRendering: shapeRendering,
        transform: transform,
        events: events,
        clipPath: clipPath
      };

      var area = _react.default.cloneElement(pathComponent, (0, _assign2.default)({
        key: "".concat(id, "-area"),
        style: (0, _assign2.default)({}, style, {
          stroke: areaStroke
        }),
        d: areaFunction(data)
      }, sharedProps));

      var line = renderLine ? _react.default.cloneElement(pathComponent, (0, _assign2.default)({
        key: "".concat(id, "-area-stroke"),
        style: (0, _assign2.default)({}, style, {
          fill: "none"
        }),
        d: lineFunction(data)
      }, sharedProps)) : null;
      return renderLine ? _react.default.cloneElement(groupComponent, {}, [area, line]) : area;
    }
  }]);

  return Area;
}(_react.default.Component);

exports.default = Area;
Object.defineProperty(Area, "propTypes", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: _objectSpread({}, _victoryCore.CommonProps.primitiveProps, {
    groupComponent: _propTypes.default.element,
    interpolation: _propTypes.default.string,
    pathComponent: _propTypes.default.element
  })
});
Object.defineProperty(Area, "defaultProps", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    groupComponent: _react.default.createElement("g", null),
    pathComponent: _react.default.createElement(_victoryCore.Path, null)
  }
});